/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.failover;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasFailover;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.util.ConnectorFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Utils;
import java.sql.SQLException;
import java.util.Properties;

public class YasFailoverProcessor {
    private final int failoverType;
    private final String failoverMethod;
    private final int failoverRetries;
    private final int failoverDelay;
    private static final int FO_EVENT_BEGIN = 1;
    private static final int FO_EVENT_END = 2;
    private static final int FO_EVENT_ABORT = 3;
    private static final int FO_EVENT_REAUTH = 4;
    private static final int FO_EVENT_ERROR = 5;
    private static final int FO_EVENT_RETRY = 6;
    private static final int FO_EVENT_UNKNOWN = 7;
    private static final String YAS_FO_TYPE_SESSION = "session";
    private static final String YAS_FO_TYPE_SELECT = "select";
    private HostSpec[] hostSpecs;
    private YasFailover appCallback = null;
    private Object appCallbackObject = null;
    private boolean needReTry = false;
    private YasLinkInfo preConnectLinkInfo = null;
    private SessionImpl session;
    private Properties info;

    public YasFailoverProcessor(Session session, Properties properties, HostSpec[] hostSpecArray) throws SQLException {
        this.failoverType = this.a(YasProperty.FAILOVER_TYPE.get(properties));
        this.failoverMethod = YasProperty.FAILOVER_METHOD.get(properties);
        this.failoverRetries = YasProperty.FAILOVER_RETRIES.getInt(properties);
        this.failoverDelay = YasProperty.FAILOVER_DELAY.getInt(properties);
        this.session = (SessionImpl)session;
        this.hostSpecs = hostSpecArray;
        this.info = properties;
        this.a();
    }

    private int a(String string) {
        if (string == null) {
            return 3;
        }
        if (string.equalsIgnoreCase(YAS_FO_TYPE_SESSION)) {
            return 1;
        }
        if (string.equalsIgnoreCase(YAS_FO_TYPE_SELECT)) {
            return 2;
        }
        return 4;
    }

    private void a() throws SQLException {
        if (this.failoverType != 1) {
            throw SQLError.createSQLException("failoverType only support session", YasState.DATA_ERROR);
        }
        if (!this.failoverMethod.equalsIgnoreCase("basic")) {
            throw SQLError.createSQLException("failoverMethod only support basic", YasState.DATA_ERROR);
        }
    }

    public void registerTAFCallback(YasFailover yasFailover, Object object) {
        this.appCallback = yasFailover;
        this.appCallbackObject = object;
    }

    private int a(int n, int n2) {
        int n3 = 0;
        if (this.appCallback != null) {
            n3 = this.appCallback.callbackFn(this.session.getConnection(), this.appCallbackObject, n, n2);
        }
        return n3;
    }

    private void b() throws SQLException {
        YasLinkInfo yasLinkInfo = this.c();
        if (yasLinkInfo == null) {
            throw SQLError.createSQLException("failover reconnect fail", YasState.IO_ERROR);
        }
        this.session.refreshAfterFailover(yasLinkInfo);
    }

    private SQLException a(SQLException sQLException) {
        this.needReTry = false;
        try {
            if (this.preConnectLinkInfo == null) {
                this.b();
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            try {
                int n = this.a(this.failoverType, 5);
                if (n == 6) {
                    this.needReTry = true;
                }
            }
            catch (Throwable throwable) {
                sQLException = SQLError.createSQLException(throwable.getMessage(), YasState.UNEXPECTED_ERROR);
            }
        }
        try {
            this.a(this.failoverType, 2);
        }
        catch (Throwable throwable) {
            sQLException = SQLError.createSQLException(throwable.getMessage(), YasState.UNEXPECTED_ERROR);
        }
        return sQLException;
    }

    public void doTransparentAppFailover() throws SQLException {
        SQLException sQLException = null;
        try {
            this.a(this.failoverType, 1);
        }
        catch (Throwable throwable) {
            sQLException = SQLError.createSQLException(throwable.getMessage(), YasState.UNEXPECTED_ERROR);
        }
        do {
            SQLException sQLException2 = this.a(sQLException);
            if (this.needReTry) continue;
            sQLException = sQLException2;
        } while (this.needReTry);
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private YasLinkInfo c() {
        if (this.appCallback != null) {
            return this.connect();
        }
        for (int i = 0; i < this.failoverRetries; ++i) {
            YasLinkInfo yasLinkInfo = this.connect();
            if (yasLinkInfo != null) {
                return yasLinkInfo;
            }
            try {
                Thread.sleep(Utils.toMillisecond(this.failoverDelay));
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    public YasLinkInfo connect() {
        String string = this.session.getConnection().getServerType();
        try {
            HostConnector hostConnector = ConnectorFactory.generateConnector(this.session, this.hostSpecs, string);
            hostConnector.checkConfigurations(this.info);
            return hostConnector.failoverConnect(this.session.getUser(), this.info);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int getFailoverType() {
        return this.failoverType;
    }
}

