/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.CallableStatementWrapper;
import com.yashandb.jdbc.pool.PreparedStatementWrapper;
import com.yashandb.jdbc.pool.StatementWrapper;
import com.yashandb.jdbc.pool.YasPooledConnection;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ConnectionWrapper
implements Connection {
    protected Connection physicalConn = null;
    protected YasPooledConnection pooledConnection;
    private boolean closed;

    public ConnectionWrapper(YasPooledConnection yasPooledConnection, Connection connection) {
        this.physicalConn = connection;
        this.pooledConnection = yasPooledConnection;
        this.closed = false;
    }

    protected SQLException checkConnectionError(SQLException sQLException) {
        if (this.pooledConnection != null) {
            this.pooledConnection.callConnectionEventListeners(1, sQLException);
        }
        return sQLException;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.a();
            this.physicalConn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            this.a();
            this.physicalConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getCatalog();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.physicalConn.isClosed();
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.a();
            this.physicalConn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getHoldability();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getMetaData();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.a();
            this.physicalConn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            this.a();
            return this.physicalConn.setSavepoint();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            this.a();
            return this.physicalConn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.a();
            this.physicalConn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.physicalConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.a();
            this.physicalConn.clearWarnings();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.a();
            this.physicalConn.commit();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.a();
            return StatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.createStatement());
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            this.a();
            return StatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            this.a();
            return StatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            this.a();
            return this.physicalConn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            this.a();
            return CallableStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareCall(string));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.a();
            return CallableStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareCall(string, n, n2));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.a();
            return CallableStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareCall(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            this.a();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(string));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.a();
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.a();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(string, n, n2));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.a();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            this.a();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(string, n));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            this.a();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(string, nArray));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            this.a();
            return PreparedStatementWrapper.getInstance(this, this.pooledConnection, this.physicalConn.prepareStatement(string, stringArray));
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.a();
            this.physicalConn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.a();
            this.physicalConn.rollback();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.a();
            this.physicalConn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.close(true);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean bl) throws SQLException {
        YasPooledConnection yasPooledConnection = this.pooledConnection;
        synchronized (yasPooledConnection) {
            if (this.closed) {
                return;
            }
            if (bl) {
                this.pooledConnection.callConnectionEventListeners(2, null);
            }
            this.closed = true;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.a();
        this.physicalConn.setSchema(string);
    }

    @Override
    public String getSchema() throws SQLException {
        this.a();
        return this.physicalConn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.a();
            this.physicalConn.abort(executor);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        try {
            this.a();
            this.physicalConn.setNetworkTimeout(executor, n);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.a();
            return this.physicalConn.getNetworkTimeout();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.a();
            return this.physicalConn.createClob();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.a();
            return this.physicalConn.createBlob();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.a();
            return this.physicalConn.createNClob();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.a();
            return this.physicalConn.createSQLXML();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public synchronized boolean isValid(int n) throws SQLException {
        try {
            this.a();
            return this.physicalConn.isValid(n);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.a();
            this.physicalConn.setClientInfo(string, string2);
        }
        catch (SQLException sQLException) {
            try {
                throw this.checkConnectionError(sQLException);
            }
            catch (SQLException sQLException2) {
                SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
                sQLClientInfoException.initCause(sQLException2);
                throw sQLClientInfoException;
            }
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.a();
            this.physicalConn.setClientInfo(properties);
        }
        catch (SQLException sQLException) {
            try {
                throw this.checkConnectionError(sQLException);
            }
            catch (SQLException sQLException2) {
                SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
                sQLClientInfoException.initCause(sQLException2);
                throw sQLClientInfoException;
            }
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            return this.physicalConn.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.physicalConn.getClientInfo();
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            this.a();
            return this.physicalConn.createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        try {
            this.a();
            return this.physicalConn.createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    public synchronized Object unwrap(Class clazz) throws SQLException {
        try {
            this.a();
            return this.physicalConn.unwrap(clazz);
        }
        catch (SQLException sQLException) {
            throw this.checkConnectionError(sQLException);
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        boolean bl = clazz.isInstance(this);
        if (bl) {
            return true;
        }
        return clazz.isAssignableFrom(Connection.class) || clazz.isAssignableFrom(AutoCloseable.class);
    }

    private void a() throws SQLException {
        if (this.physicalConn == null || this.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
    }
}

