/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.ConnectionWrapper;
import com.yashandb.jdbc.pool.StatementWrapper;
import com.yashandb.jdbc.pool.YasPooledConnection;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.util.Calendar;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreparedStatementWrapper.class);

    protected static PreparedStatementWrapper getInstance(ConnectionWrapper connectionWrapper, YasPooledConnection yasPooledConnection, PreparedStatement preparedStatement) {
        return new PreparedStatementWrapper(connectionWrapper, yasPooledConnection, preparedStatement);
    }

    PreparedStatementWrapper(ConnectionWrapper connectionWrapper, YasPooledConnection yasPooledConnection, PreparedStatement preparedStatement) {
        super(connectionWrapper, yasPooledConnection, preparedStatement);
    }

    @Override
    protected SQLException checkErrorEvent(SQLException sQLException) {
        LOGGER.warn("checkErrorEvent:" + sQLException.getMessage());
        if (this.pooledConnection != null) {
            this.pooledConnection.callStatementEventListeners(3, (PreparedStatement)this.wrappedStatement, sQLException);
        }
        return sQLException;
    }

    protected void checkStmtNull() throws SQLException {
        if (this.wrappedStatement == null) {
            throw this.checkErrorEvent(this.statmentWrapperException);
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setArray(n, array);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setByte(n, by);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setClob(n, clob);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setDate(n, date);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setDouble(n, d);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setFloat(n, f);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setInt(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setLong(n, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStmtNull();
        try {
            return ((PreparedStatement)this.wrappedStatement).getMetaData();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNull(n, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setObject(n, object);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkStmtNull();
        try {
            return ((PreparedStatement)this.wrappedStatement).getParameterMetaData();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setRef(n, ref);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setShort(n, s);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setString(n, string);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setTime(n, time);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).addBatch();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).clearParameters();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkStmtNull();
        try {
            return ((PreparedStatement)this.wrappedStatement).execute();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = null;
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            resultSet = ((PreparedStatement)this.wrappedStatement).executeQuery();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
        return resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkStmtNull();
        try {
            return ((PreparedStatement)this.wrappedStatement).executeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNString(n, string);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setClob(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean isWrapperFor(Class clazz) throws SQLException {
        boolean bl = clazz.isInstance(this);
        if (bl) {
            return true;
        }
        String string = clazz.getName();
        return string.equals("com.yashandb.jdbc.YasStatement") || string.equals("java.sql.Statement") || string.equals("java.sql.Wrapper") || string.equals("java.sql.PreparedStatement");
    }

    @Override
    public synchronized Object unwrap(Class clazz) throws SQLException {
        try {
            if (clazz.isAssignableFrom(Statement.class) || clazz.isAssignableFrom(PreparedStatement.class) || clazz.isAssignableFrom(Wrapper.class)) {
                return clazz.cast(this);
            }
        }
        catch (ClassCastException classCastException) {
            throw this.checkErrorEvent(new SQLException("Common.UnableToUnwrap:" + classCastException.getMessage()));
        }
        return null;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.pooledConnection == null) {
            return;
        }
        try {
            super.close();
        }
        finally {
            this.pooledConnection.callStatementEventListeners(4, this, null);
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.checkStmtNull();
        try {
            return ((PreparedStatement)this.wrappedStatement).executeLargeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setObject(n, object, sQLType);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.checkStmtNull();
        try {
            ((PreparedStatement)this.wrappedStatement).setObject(n, object, sQLType, n2);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }
}

