/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.ConnectionWrapper;
import com.yashandb.jdbc.pool.YasPooledConnection;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;

public class StatementWrapper
implements Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementWrapper.class);
    protected Statement wrappedStatement;
    protected ConnectionWrapper wrappedConn;
    protected YasPooledConnection pooledConnection;
    protected SQLException statmentWrapperException = new SQLException("Statement.AlreadyClosed");

    protected static StatementWrapper getInstance(ConnectionWrapper connectionWrapper, YasPooledConnection yasPooledConnection, Statement statement) {
        return new StatementWrapper(connectionWrapper, yasPooledConnection, statement);
    }

    public StatementWrapper(ConnectionWrapper connectionWrapper, YasPooledConnection yasPooledConnection, Statement statement) {
        this.pooledConnection = yasPooledConnection;
        this.wrappedStatement = statement;
        this.wrappedConn = connectionWrapper;
    }

    protected SQLException checkErrorEvent(SQLException sQLException) {
        LOGGER.warn("checkErrorEvent:" + sQLException.getMessage());
        if (this.pooledConnection != null) {
            this.pooledConnection.callConnectionEventListeners(1, sQLException);
        }
        return sQLException;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedConn;
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setCursorName(string);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getFetchDirection();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getFetchSize();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getGeneratedKeys();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getMaxFieldSize();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getMaxRows();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getMoreResults();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getMoreResults(n);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getQueryTimeout();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getResultSet();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getResultSetConcurrency();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getResultSetHoldability();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getResultSetType();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getUpdateCount();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getWarnings();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.addBatch(string);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.cancel();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.clearBatch();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.clearWarnings();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void close() throws SQLException {
        block6: {
            try {
                if (this.wrappedStatement != null) {
                    this.wrappedStatement.close();
                    break block6;
                }
                throw this.statmentWrapperException;
            }
            catch (SQLException sQLException) {
                throw this.checkErrorEvent(sQLException);
            }
            finally {
                this.wrappedStatement = null;
            }
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.execute(string, n);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.execute(string, nArray);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.execute(string, stringArray);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.execute(string);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeBatch();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            return this.wrappedStatement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeUpdate(string, n);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeUpdate(string, nArray);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeUpdate(string, stringArray);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeUpdate(string);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    public synchronized Object unwrap(Class clazz) throws SQLException {
        try {
            if (clazz.isAssignableFrom(Statement.class) || clazz.isAssignableFrom(Wrapper.class)) {
                return clazz.cast(this);
            }
            throw new SQLException("Common.UnableToUnwrap");
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        boolean bl = clazz.isInstance(this);
        if (bl) {
            return true;
        }
        String string = clazz.getName();
        return string.equals("com.yashandb.jdbc.YasStatement") || string.equals("java.sql.Statement") || string.equals("java.sql.Wrapper");
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.isClosed();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.isPoolable();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.closeOnCompletion();
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.isCloseOnCompletion();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeLargeBatch();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeLargeUpdate(string);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeLargeUpdate(string, n);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeLargeUpdate(string, nArray);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.executeLargeUpdate(string, stringArray);
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getLargeMaxRows();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            if (this.wrappedStatement != null) {
                return this.wrappedStatement.getLargeUpdateCount();
            }
            throw this.statmentWrapperException;
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        try {
            if (this.wrappedStatement == null) {
                throw this.statmentWrapperException;
            }
            this.wrappedStatement.setLargeMaxRows(l);
        }
        catch (SQLException sQLException) {
            throw this.checkErrorEvent(sQLException);
        }
    }
}

