/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.pool;

import com.yashandb.jdbc.pool.ConnectionWrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class YasPooledConnection
implements Serializable,
PooledConnection {
    public static final int YAS_CONNECTION_ERROR_EVENT = 1;
    public static final int YAS_CONNECTION_CLOSED_EVENT = 2;
    public static final int YAS_STATEMENT_ERROR_EVENT = 3;
    public static final int YAS_STATEMENT_CLOSED_EVENT = 4;
    private static final long serialVersionUID = 6677891687109972348L;
    protected transient Connection logicalHandle = null;
    protected transient Connection physicalConn = null;
    private transient Map connectionEventListeners;
    private transient Map statementEventListeners;

    protected static YasPooledConnection getInstance(Connection connection) {
        return new YasPooledConnection(connection);
    }

    public YasPooledConnection(Connection connection) {
        this.physicalConn = connection;
        this.connectionEventListeners = new HashMap();
        this.statementEventListeners = new HashMap();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            SQLException sQLException = new SQLException("Physical Connection doesn't exist");
            this.callConnectionEventListeners(1, sQLException);
            throw sQLException;
        }
        try {
            if (this.logicalHandle != null) {
                this.logicalHandle.close();
            }
            this.logicalHandle = new ConnectionWrapper(this, this.physicalConn);
        }
        catch (SQLException sQLException) {
            this.callConnectionEventListeners(1, sQLException);
            throw sQLException;
        }
        return this.logicalHandle;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.close();
            this.physicalConn = null;
        }
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.clear();
            this.connectionEventListeners = null;
        }
        if (this.statementEventListeners != null) {
            this.statementEventListeners.clear();
            this.statementEventListeners = null;
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.put(connectionEventListener, connectionEventListener);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.remove(connectionEventListener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (this.statementEventListeners != null) {
            this.statementEventListeners.put(statementEventListener, statementEventListener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        if (this.statementEventListeners != null) {
            this.statementEventListeners.remove(statementEventListener);
        }
    }

    protected synchronized void callConnectionEventListeners(int n, SQLException sQLException) {
        if (this.connectionEventListeners == null) {
            return;
        }
        Iterator iterator = this.connectionEventListeners.entrySet().iterator();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next().getValue();
            if (n == 2) {
                connectionEventListener.connectionClosed(connectionEvent);
                continue;
            }
            if (n != 1) continue;
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    protected synchronized void callStatementEventListeners(int n, PreparedStatement preparedStatement, SQLException sQLException) {
        if (this.statementEventListeners == null) {
            return;
        }
        Iterator iterator = this.statementEventListeners.entrySet().iterator();
        StatementEvent statementEvent = new StatementEvent(this, preparedStatement, sQLException);
        while (iterator.hasNext()) {
            StatementEventListener statementEventListener = (StatementEventListener)iterator.next().getValue();
            if (n == 4) {
                statementEventListener.statementClosed(statementEvent);
                continue;
            }
            if (n != 3) continue;
            statementEventListener.statementErrorOccurred(statementEvent);
        }
    }
}

