/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonArray;
import com.yashandb.json.YasonBinary;
import com.yashandb.json.YasonBoolean;
import com.yashandb.json.YasonByte;
import com.yashandb.json.YasonDate;
import com.yashandb.json.YasonDecimal;
import com.yashandb.json.YasonDouble;
import com.yashandb.json.YasonExceptions;
import com.yashandb.json.YasonFloat;
import com.yashandb.json.YasonInt;
import com.yashandb.json.YasonLong;
import com.yashandb.json.YasonNull;
import com.yashandb.json.YasonObject;
import com.yashandb.json.YasonShort;
import com.yashandb.json.YasonString;
import com.yashandb.json.YasonTextGenerator;
import com.yashandb.json.YasonTime;
import com.yashandb.json.YasonTimestamp;
import com.yashandb.json.YasonType;
import com.yashandb.json.YasonValue;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractYasonValue
implements YasonValue {
    protected static final Map escapedSymbols = new HashMap();

    public static YasonValue buildYasonValue(byte[] byArray, int n) throws SQLException {
        YasonType yasonType = YasonType.values()[byArray[n] - 1];
        switch (yasonType) {
            case YASON_OBJECT: {
                return YasonObject.buildYasonValue(byArray, n);
            }
            case YASON_ARRAY: {
                return YasonArray.buildYasonValue(byArray, n);
            }
            case YASON_STRING: {
                return YasonString.buildYasonValue(byArray, n);
            }
            case YASON_NUMBER: {
                return YasonDecimal.buildYasonValue(byArray, n);
            }
            case YASON_BOOLEAN: {
                return YasonBoolean.buildYasonValue(byArray, n);
            }
            case YASON_NULL: {
                return YasonNull.buildYasonValue();
            }
            case YASON_BYTE: {
                return YasonByte.buildYasonValue(byArray, n);
            }
            case YASON_SHORT: {
                return YasonShort.buildYasonValue(byArray, n);
            }
            case YASON_INT: {
                return YasonInt.buildYasonValue(byArray, n);
            }
            case YASON_BIGINT: {
                return YasonLong.buildYasonValue(byArray, n);
            }
            case YASON_FLOAT: {
                return YasonFloat.buildYasonValue(byArray, n);
            }
            case YASON_DOUBLE: {
                return YasonDouble.buildYasonValue(byArray, n);
            }
            case YASON_BINARY: {
                return YasonBinary.buildYasonValue(byArray, n);
            }
            case YASON_TIMESTAMP: {
                return YasonTimestamp.buildYasonValue(byArray, n);
            }
            case YASON_DATE: {
                return YasonDate.buildYasonValue(byArray, n);
            }
            case YASON_TIME: {
                return YasonTime.buildYasonValue(byArray, n);
            }
        }
        return null;
    }

    protected int getDepth(int n) throws SQLException {
        return n;
    }

    @Override
    public int getDepth() throws SQLException {
        return this.getDepth(0);
    }

    public static String replaceSpecialCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (escapedSymbols.containsKey(Character.valueOf(string.charAt(i)))) {
                stringBuilder.append((String)escapedSymbols.get(Character.valueOf(string.charAt(i))));
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getString() {
        StringWriter stringWriter = new StringWriter();
        YasonTextGenerator yasonTextGenerator = new YasonTextGenerator(stringWriter);
        yasonTextGenerator.write(this);
        yasonTextGenerator.close();
        return stringWriter.toString();
    }

    protected abstract byte[] internalGetBinaryData() throws SQLException;

    @Override
    public byte[] getBinaryData() throws SQLException {
        this.getDepth();
        return this.internalGetBinaryData();
    }

    protected static void checkYear(int n) {
        if (n < 1 || n > 9999) {
            throw YasonExceptions.BAD_YEAR.create(YasonExceptions.EXCEPTION_FACTORY, n);
        }
    }

    protected static void checkYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        AbstractYasonValue.checkYear(n);
    }

    protected String getNanoStr(int n) {
        n = Math.round((float)n / 1000.0f);
        String string = String.valueOf(n);
        string = "000000".substring(0, 6 - string.length()) + string;
        while (string.endsWith("0")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        escapedSymbols.put(Character.valueOf('\b'), "\\b");
        escapedSymbols.put(Character.valueOf('\t'), "\\t");
        escapedSymbols.put(Character.valueOf('\n'), "\\n");
        escapedSymbols.put(Character.valueOf('\f'), "\\f");
        escapedSymbols.put(Character.valueOf('\r'), "\\r");
        escapedSymbols.put(Character.valueOf('\"'), "\\\"");
        escapedSymbols.put(Character.valueOf('\\'), "\\\\");
    }
}

