/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.BufferPoolImpl;
import com.yashandb.json.JsonLocationImpl;
import com.yashandb.json.YasonExceptions;
import com.yashandb.json.YasonParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;

public class JsonTokenizer
implements Closeable {
    private static final int[] HEX;
    private static final int HEX_LENGTH;
    private final BufferPoolImpl bufferPool;
    private final Reader reader;
    private char[] buf;
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private long lineNo = 1L;
    private long lastLineOffset = 0L;
    private long bufferOffset = 0L;
    private boolean minus;
    private boolean fracOrExp;
    private BigDecimal bd;

    JsonTokenizer(Reader reader, BufferPoolImpl bufferPoolImpl) {
        this.reader = reader;
        this.bufferPool = bufferPoolImpl;
        this.buf = bufferPoolImpl.take();
    }

    private YasonExceptions.ExceptionFactory j() {
        return YasonExceptions.EXCEPTION_FACTORY;
    }

    private void k() {
        boolean bl = true;
        this.storeBegin = this.storeEnd = this.readBegin;
        block4: while (!this.a(bl)) {
            int n = this.r();
            if (n < 32) {
                throw this.d(n);
            }
            switch (n) {
                case 34: {
                    return;
                }
                case 92: {
                    bl = false;
                    this.l();
                    continue block4;
                }
            }
            this.a(bl, (char)n);
        }
        return;
    }

    private void a(boolean bl, char c) {
        if (!bl) {
            this.buf[this.storeEnd] = c;
        }
        ++this.storeEnd;
    }

    private boolean a(boolean bl) {
        if (bl) {
            char c;
            while (this.readBegin < this.readEnd && (c = this.buf[this.readBegin]) >= ' ' && c != '\\') {
                if (c == '\"') {
                    this.storeEnd = this.readBegin++;
                    return true;
                }
                ++this.readBegin;
            }
            this.storeEnd = this.readBegin;
        }
        return false;
    }

    private void l() {
        int n = this.r();
        switch (n) {
            case 34: 
            case 47: 
            case 92: {
                this.buf[this.storeEnd++] = (char)n;
                break;
            }
            case 98: {
                this.buf[this.storeEnd++] = 8;
                break;
            }
            case 102: {
                this.buf[this.storeEnd++] = 12;
                break;
            }
            case 110: {
                this.buf[this.storeEnd++] = 10;
                break;
            }
            case 114: {
                this.buf[this.storeEnd++] = 13;
                break;
            }
            case 116: {
                this.buf[this.storeEnd++] = 9;
                break;
            }
            case 117: {
                int n2 = 0;
                for (int i = 0; i < 4; ++i) {
                    int n3;
                    int n4 = this.r();
                    int n5 = n3 = n4 >= 0 && n4 < HEX_LENGTH ? HEX[n4] : -1;
                    if (n3 < 0) {
                        throw this.d(n4);
                    }
                    n2 = n2 << 4 | n3;
                }
                this.buf[this.storeEnd++] = (char)n2;
                break;
            }
            default: {
                throw this.d(n);
            }
        }
    }

    private int m() {
        if (this.readBegin < this.readEnd) {
            return this.buf[this.readBegin++];
        }
        this.storeEnd = this.readBegin;
        return this.r();
    }

    private void a(int n) {
        this.storeBegin = this.storeEnd = this.readBegin - 1;
        if ((n = this.b(n)) == 48) {
            n = this.m();
        } else {
            while ((n = this.m()) >= 48 && n <= 57) {
            }
        }
        if (n == 46) {
            this.fracOrExp = true;
            int n2 = 0;
            do {
                n = this.m();
                ++n2;
            } while (n >= 48 && n <= 57);
            if (n2 == 1) {
                throw this.d(n);
            }
        }
        if ((n = this.c(n)) != -1) {
            --this.readBegin;
            this.storeEnd = this.readBegin;
        }
    }

    private int b(int n) {
        if (n == 45) {
            this.minus = true;
            n = this.m();
            if (n < 48 || n > 57) {
                throw this.d(n);
            }
        }
        return n;
    }

    private int c(int n) {
        if (n == 101 || n == 69) {
            this.fracOrExp = true;
            n = this.m();
            if (n == 43 || n == 45) {
                n = this.m();
            }
            int n2 = 0;
            while (n >= 48 && n <= 57) {
                n = this.m();
                ++n2;
            }
            if (n2 == 0) {
                throw this.d(n);
            }
        }
        return n;
    }

    private void n() {
        int n = this.r();
        if (n != 114) {
            throw this.a(n, 'r');
        }
        int n2 = this.r();
        if (n2 != 117) {
            throw this.a(n2, 'u');
        }
        int n3 = this.r();
        if (n3 != 101) {
            throw this.a(n3, 'e');
        }
    }

    private void o() {
        int n = this.r();
        if (n != 97) {
            throw this.a(n, 'a');
        }
        int n2 = this.r();
        if (n2 != 108) {
            throw this.a(n2, 'l');
        }
        int n3 = this.r();
        if (n3 != 115) {
            throw this.a(n3, 's');
        }
        int n4 = this.r();
        if (n4 != 101) {
            throw this.a(n4, 'e');
        }
    }

    private void p() {
        int n = this.r();
        if (n != 117) {
            throw this.a(n, 'u');
        }
        int n2 = this.r();
        if (n2 != 108) {
            throw this.a(n2, 'l');
        }
        int n3 = this.r();
        if (n3 != 108) {
            throw this.a(n3, 'l');
        }
    }

    JsonToken a() {
        this.t();
        int n = this.r();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            if (n == 13) {
                ++this.lineNo;
                n = this.r();
                if (n != 10) {
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin - 1L;
                    continue;
                }
                this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
            } else if (n == 10) {
                ++this.lineNo;
                this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
            }
            n = this.r();
        }
        switch (n) {
            case -1: {
                return JsonToken.EOF;
            }
            case 34: {
                this.k();
                return JsonToken.STRING;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.a(n);
                return JsonToken.NUMBER;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 102: {
                this.o();
                return JsonToken.FALSE;
            }
            case 110: {
                this.p();
                return JsonToken.NULL;
            }
            case 116: {
                this.n();
                return JsonToken.TRUE;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
        }
        throw this.d(n);
    }

    boolean b() {
        this.t();
        int n = this.q();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            if (n == 13) {
                ++this.lineNo;
                ++this.readBegin;
                n = this.q();
                if (n != 10) {
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                    continue;
                }
                this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
            } else if (n == 10) {
                ++this.lineNo;
                this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
            }
            ++this.readBegin;
            n = this.q();
        }
        return n != -1;
    }

    private int q() {
        try {
            if (this.readBegin == this.readEnd) {
                int n = this.s();
                if (n == -1) {
                    return -1;
                }
                assert (n != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n;
            }
            return this.buf[this.readBegin];
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.j(), iOException, new Object());
        }
    }

    JsonLocationImpl c() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset, this.bufferOffset + (long)this.readBegin - 1L);
    }

    JsonLocationImpl d() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset + 1L, this.bufferOffset + (long)this.readBegin);
    }

    private int r() {
        try {
            if (this.readBegin == this.readEnd) {
                int n = this.s();
                if (n == -1) {
                    return -1;
                }
                assert (n != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.j(), iOException, new Object());
        }
    }

    private int s() throws IOException {
        if (this.storeEnd != 0) {
            int n = this.storeEnd - this.storeBegin;
            if (n > 0) {
                if (n == this.buf.length) {
                    char[] cArray = Arrays.copyOf(this.buf, 2 * this.buf.length);
                    this.bufferPool.recycle(this.buf);
                    this.buf = cArray;
                } else {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, n);
                    this.storeEnd = n;
                    this.storeBegin = 0;
                    this.bufferOffset += (long)(this.readBegin - this.storeEnd);
                }
            } else {
                this.storeEnd = 0;
                this.storeBegin = 0;
                this.bufferOffset += (long)this.readBegin;
            }
        } else {
            this.bufferOffset += (long)this.readBegin;
        }
        return this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
    }

    private void t() {
        if (this.storeEnd != 0) {
            this.storeBegin = 0;
            this.storeEnd = 0;
            this.bd = null;
            this.minus = false;
            this.fracOrExp = false;
        }
    }

    String e() {
        return new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
    }

    BigDecimal f() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int g() {
        int n;
        int n2 = this.storeEnd - this.storeBegin;
        if (this.fracOrExp || n2 > 9 && (!this.minus || n2 > 10)) {
            return this.f().intValue();
        }
        int n3 = 0;
        int n4 = n = this.minus ? 1 : 0;
        while (n < n2) {
            n3 = n3 * 10 + (this.buf[this.storeBegin + n] - 48);
            ++n;
        }
        return this.minus ? -n3 : n3;
    }

    long h() {
        int n;
        int n2 = this.storeEnd - this.storeBegin;
        if (this.fracOrExp || n2 > 18 && (!this.minus || n2 > 19)) {
            return this.f().longValue();
        }
        long l = 0L;
        int n3 = n = this.minus ? 1 : 0;
        while (n < n2) {
            l = l * 10L + (long)(this.buf[this.storeBegin + n] - 48);
            ++n;
        }
        return this.minus ? -l : l;
    }

    boolean i() {
        return !this.fracOrExp || this.f().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.bufferPool.recycle(this.buf);
    }

    private RuntimeException d(int n) {
        JsonLocationImpl jsonLocationImpl = this.c();
        return YasonExceptions.TOKEN_UNEXPECTED_CHAR.create(this.j(), this.e(n), jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber());
    }

    private RuntimeException a(int n, char c) {
        JsonLocationImpl jsonLocationImpl = this.c();
        return YasonExceptions.TOKEN_EXPECTED_CHAR.create(this.j(), this.e(n), jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber(), this.e(c));
    }

    private String e(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n >= 32 && n <= 126) {
            stringBuilder.append("'");
            stringBuilder.appendCodePoint(n);
            stringBuilder.append("'");
        } else {
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toHexString(n));
        }
        return stringBuilder.toString();
    }

    static {
        int n;
        HEX = new int[128];
        Arrays.fill(HEX, -1);
        for (n = 48; n <= 57; ++n) {
            JsonTokenizer.HEX[n] = n - 48;
        }
        for (n = 65; n <= 70; ++n) {
            JsonTokenizer.HEX[n] = 10 + n - 65;
        }
        for (n = 97; n <= 102; ++n) {
            JsonTokenizer.HEX[n] = 10 + n - 97;
        }
        HEX_LENGTH = HEX.length;
    }

    static enum JsonToken {
        CURLYOPEN(YasonParser.Event.START_OBJECT, false),
        SQUAREOPEN(YasonParser.Event.START_ARRAY, false),
        COLON((YasonParser.Event)null, false),
        COMMA((YasonParser.Event)null, false),
        STRING(YasonParser.Event.VALUE_STRING, true),
        NUMBER(YasonParser.Event.VALUE_DECIMAL, true),
        TRUE(YasonParser.Event.VALUE_TRUE, true),
        FALSE(YasonParser.Event.VALUE_FALSE, true),
        NULL(YasonParser.Event.VALUE_NULL, true),
        CURLYCLOSE(YasonParser.Event.END_OBJECT, false),
        SQUARECLOSE(YasonParser.Event.END_ARRAY, false),
        EOF((YasonParser.Event)null, false);

        private final YasonParser.Event event;
        private final boolean value;

        /*
         * WARNING - void declaration
         */
        private JsonToken() {
            void var4_1;
            void var3_2;
            this.event = var3_2;
            this.value = var4_1;
        }

        YasonParser.Event a() {
            return this.event;
        }

        boolean b() {
            return this.value;
        }
    }
}

