/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.json.AbstractYasonValue;
import com.yashandb.json.YasonBinary;
import com.yashandb.json.YasonBoolean;
import com.yashandb.json.YasonByte;
import com.yashandb.json.YasonDate;
import com.yashandb.json.YasonDecimal;
import com.yashandb.json.YasonDouble;
import com.yashandb.json.YasonFloat;
import com.yashandb.json.YasonInt;
import com.yashandb.json.YasonLong;
import com.yashandb.json.YasonNull;
import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonShort;
import com.yashandb.json.YasonString;
import com.yashandb.json.YasonTime;
import com.yashandb.json.YasonTimestamp;
import com.yashandb.json.YasonType;
import com.yashandb.json.YasonValue;
import com.yashandb.protocol.BaseBuffer;
import com.yashandb.protocol.Packet;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class YasonArray
extends AbstractYasonValue
implements List {
    private final List values = new LinkedList();
    private static final int ARRAY_ELEMENT_OFFSET_LENGTH = 5;
    private static final int INLINE_OFFSET = -1;

    public YasonArray() {
    }

    public YasonArray(YasonArray yasonArray) {
        this.values.addAll(yasonArray);
    }

    public static YasonArray buildYasonValue(byte[] byArray, int n) throws SQLException {
        int n2;
        int n3;
        YasonArray yasonArray = new YasonArray();
        YasonArray yasonArray2 = new YasonArray();
        int n4 = ByteConverter.int4(byArray, n + 1);
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n + 1 + 4, byArray2, 0, n4);
        int n5 = ByteConverter.uint2(byArray2, 0);
        int[] nArray = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = 2 + n3 * 5;
            byte by = byArray2[n2];
            if (YasonArray.a(YasonType.getYasonType(by))) {
                YasonValue yasonValue = AbstractYasonValue.buildYasonValue(byArray2, n2);
                yasonArray2.add(yasonValue);
                nArray[n3] = -1;
                continue;
            }
            nArray[n3] = ByteConverter.int4(byArray2, n2 + 1);
        }
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            if (nArray[n2] == -1) {
                yasonArray.add(yasonArray2.get(n3));
                ++n3;
                continue;
            }
            YasonValue yasonValue = AbstractYasonValue.buildYasonValue(byArray2, nArray[n2]);
            yasonArray.add(yasonValue);
        }
        return yasonArray;
    }

    @Override
    public List getValue() {
        return this.values;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_ARRAY;
    }

    @Override
    protected int getDepth(int n) throws SQLException {
        int n2 = n;
        for (YasonValue yasonValue : this.values) {
            n2 = Math.max(n2, ((AbstractYasonValue)yasonValue).getDepth(n + 1));
        }
        if (n2 > 100) {
            throw SQLError.createSQLException("The nesting depth of JSON cannot exceed 100", YasState.DATA_ERROR);
        }
        return n2;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.values.contains(object);
    }

    @Override
    public Iterator iterator() {
        return this.values.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.values.toArray(objectArray);
    }

    @Override
    public boolean add(YasonValue yasonValue) {
        return this.values.add(yasonValue);
    }

    @Override
    public boolean remove(Object object) {
        return this.values.remove(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.values.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.values.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.values.addAll(n, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.values.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.values.retainAll(collection);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public YasonValue get(int n) {
        return (YasonValue)this.values.get(n);
    }

    public YasonValue set(int n, YasonValue yasonValue) {
        return this.values.set(n, yasonValue);
    }

    public void add(int n, YasonValue yasonValue) {
        this.values.add(n, yasonValue);
    }

    public YasonValue remove(int n) {
        return (YasonValue)this.values.remove(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.values.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.values.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.values.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.values.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.values.subList(n, n2);
    }

    @Override
    protected byte[] internalGetBinaryData() throws SQLException {
        Object object;
        int n;
        if (this.size() > 65535) {
            throw SQLError.createSQLException("The number of elements cannot exceed 65535", YasState.DATA_ERROR);
        }
        int n2 = 2 + this.values.size() * 5;
        Packet packet = new Packet(n2, StandardCharsets.UTF_8);
        packet.writeShort(this.values.size());
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n3 = 0;
        for (n = 0; n < this.values.size(); ++n) {
            byte[] byArray;
            object = (AbstractYasonValue)this.values.get(n);
            if (YasonArray.a(object.getType())) {
                byArray = ((AbstractYasonValue)object).internalGetBinaryData();
                packet.writeBytes(byArray);
                packet.skip(4 - byArray.length + 1);
                continue;
            }
            byArray = ((AbstractYasonValue)object).internalGetBinaryData();
            linkedList.add(byArray);
            packet.writeByte((byte)object.getType().getValue());
            packet.writeInt(n2 + n3);
            n3 += byArray.length;
        }
        n = 5 + n2 + n3;
        if (n > 0x2000000) {
            throw SQLError.createSQLException("JSON data size cannot exceed 32M", YasState.DATA_ERROR);
        }
        object = new Packet(n, StandardCharsets.UTF_8);
        ((BaseBuffer)object).writeByte((byte)this.getType().getValue());
        ((BaseBuffer)object).writeInt(n2 + n3);
        ((BaseBuffer)object).writeBytes(packet.getBuffer(), 0, packet.getPostion());
        for (int i = 0; i < linkedList.size(); ++i) {
            ((BaseBuffer)object).writeBytes((byte[])linkedList.get(i));
        }
        return ((BaseBuffer)object).getBuffer();
    }

    private static boolean a(YasonType yasonType) {
        return yasonType.equals((Object)YasonType.YASON_NULL) || yasonType.equals((Object)YasonType.YASON_BOOLEAN) || yasonType.equals((Object)YasonType.YASON_BYTE) || yasonType.equals((Object)YasonType.YASON_SHORT) || yasonType.equals((Object)YasonType.YASON_INT) || yasonType.equals((Object)YasonType.YASON_FLOAT);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonArray yasonArray = (YasonArray)object;
        return Objects.equals(this.values, yasonArray.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.values);
    }

    @Override
    public boolean add(String string) {
        return this.values.add(new YasonString(string));
    }

    public void add(int n, String string) {
        this.values.add(n, new YasonString(string));
    }

    public YasonValue set(int n, String string) {
        return this.values.set(n, new YasonString(string));
    }

    public String getString(int n) {
        return ((YasonValue)this.values.get(n)).getString();
    }

    @Override
    public boolean add(BigDecimal bigDecimal) {
        return this.values.add(new YasonDecimal(bigDecimal));
    }

    public void add(int n, BigDecimal bigDecimal) {
        this.values.add(n, new YasonDecimal(bigDecimal));
    }

    public YasonValue set(int n, BigDecimal bigDecimal) {
        return this.values.set(n, new YasonDecimal(bigDecimal));
    }

    public BigDecimal getBigDecimal(int n) {
        return ((YasonNumber)this.values.get(n)).getBigDecimal();
    }

    @Override
    public boolean add(boolean bl) {
        return this.values.add(new YasonBoolean(bl));
    }

    public void add(int n, boolean bl) {
        this.values.add(n, new YasonBoolean(bl));
    }

    public YasonValue set(int n, boolean bl) {
        return this.values.set(n, new YasonBoolean(bl));
    }

    public boolean getBoolean(int n) {
        YasonValue yasonValue = (YasonValue)this.values.get(n);
        return ((YasonBoolean)yasonValue).getValue();
    }

    public boolean addNull() {
        return this.values.add(YasonNull.INSTANCE);
    }

    public void addNull(int n) {
        this.values.add(n, YasonNull.INSTANCE);
    }

    public YasonValue setNull(int n) {
        return this.values.set(n, YasonNull.INSTANCE);
    }

    public boolean isNull(int n) {
        YasonValue yasonValue = (YasonValue)this.values.get(n);
        return yasonValue instanceof YasonNull;
    }

    @Override
    public boolean add(byte by) {
        return this.values.add(new YasonByte(by));
    }

    public void add(int n, byte by) {
        this.values.add(n, new YasonByte(by));
    }

    public YasonValue set(int n, byte by) {
        return this.values.set(n, new YasonByte(by));
    }

    public byte getByte(int n) {
        return this.getBigDecimal(n).byteValue();
    }

    @Override
    public boolean add(short s) {
        return this.values.add(new YasonShort(s));
    }

    public void add(int n, short s) {
        this.values.add(n, new YasonShort(s));
    }

    public YasonValue set(int n, short s) {
        return this.values.set(n, new YasonShort(s));
    }

    public short getShort(int n) {
        return this.getBigDecimal(n).shortValue();
    }

    @Override
    public boolean add(int n) {
        return this.values.add(new YasonInt(n));
    }

    public void add(int n, int n2) {
        this.values.add(n, new YasonInt(n2));
    }

    public YasonValue set(int n, int n2) {
        return this.values.set(n, new YasonInt(n2));
    }

    public int getInt(int n) {
        return this.getBigDecimal(n).intValue();
    }

    @Override
    public boolean add(long l) {
        return this.values.add(new YasonLong(l));
    }

    public void add(int n, long l) {
        this.values.add(n, new YasonLong(l));
    }

    public YasonValue set(int n, long l) {
        return this.values.set(n, new YasonLong(l));
    }

    public long getLong(int n) {
        return this.getBigDecimal(n).longValue();
    }

    @Override
    public boolean add(float f) {
        return this.values.add(new YasonFloat(f));
    }

    public void add(int n, float f) {
        this.values.add(n, new YasonFloat(f));
    }

    public YasonValue set(int n, float f) {
        return this.values.set(n, new YasonFloat(f));
    }

    public float getFloat(int n) {
        return this.getBigDecimal(n).floatValue();
    }

    @Override
    public boolean add(double d) {
        return this.values.add(new YasonDouble(d));
    }

    public void add(int n, double d) {
        this.values.add(n, new YasonDouble(d));
    }

    public YasonValue set(int n, double d) {
        return this.values.set(n, new YasonDouble(d));
    }

    public double getDouble(int n) {
        return this.getBigDecimal(n).doubleValue();
    }

    @Override
    public boolean add(byte[] byArray) {
        return this.values.add(new YasonBinary(byArray));
    }

    public void add(int n, byte[] byArray) {
        this.values.add(n, new YasonBinary(byArray));
    }

    public YasonValue set(int n, byte[] byArray) {
        return this.values.set(n, new YasonBinary(byArray));
    }

    public byte[] getBytes(int n) {
        return ((YasonBinary)this.values.get(n)).getValue();
    }

    @Override
    public boolean add(Date date) {
        return this.values.add(new YasonDate(date));
    }

    public void add(int n, Date date) {
        this.values.add(n, new YasonDate(date));
    }

    public YasonValue set(int n, Date date) {
        return this.values.set(n, new YasonDate(date));
    }

    public Date getDate(int n) {
        return (Date)((YasonValue)this.values.get(n)).getValue();
    }

    @Override
    public boolean add(LocalDate localDate) {
        return this.values.add(new YasonDate(localDate));
    }

    public void add(int n, LocalDate localDate) {
        this.values.add(n, new YasonDate(localDate));
    }

    public YasonValue set(int n, LocalDate localDate) {
        return this.values.set(n, new YasonDate(localDate));
    }

    public LocalDate getLocalDate(int n) {
        return this.getLocalDateTime(n).toLocalDate();
    }

    @Override
    public boolean add(LocalDateTime localDateTime) {
        return this.values.add(new YasonTimestamp(localDateTime));
    }

    public void add(int n, LocalDateTime localDateTime) {
        this.values.add(n, new YasonTimestamp(localDateTime));
    }

    public YasonValue set(int n, LocalDateTime localDateTime) {
        return this.values.set(n, new YasonTimestamp(localDateTime));
    }

    public LocalDateTime getLocalDateTime(int n) {
        return LocalDateTime.ofInstant(((Date)((YasonValue)this.values.get(n)).getValue()).toInstant(), ZoneId.systemDefault());
    }

    @Override
    public boolean add(Time time) {
        return this.values.add(new YasonTime(time));
    }

    public void add(int n, Time time) {
        this.values.add(n, new YasonTime(time));
    }

    public YasonValue set(int n, Time time) {
        return this.values.set(n, new YasonTime(time));
    }

    public Time getTime(int n) {
        return new Time(((Date)((YasonValue)this.values.get(n)).getValue()).getTime());
    }

    @Override
    public boolean add(LocalTime localTime) {
        return this.values.add(new YasonTime(localTime));
    }

    public void add(int n, LocalTime localTime) {
        this.values.add(n, new YasonTime(localTime));
    }

    public YasonValue set(int n, LocalTime localTime) {
        return this.values.set(n, new YasonTime(localTime));
    }

    public LocalTime getLocalTime(int n) {
        if (this.values.get(n) instanceof YasonTime) {
            return ((YasonTime)this.values.get(n)).getLocalTime();
        }
        return this.getLocalDateTime(n).toLocalTime();
    }

    @Override
    public boolean add(Timestamp timestamp) {
        return this.values.add(new YasonTimestamp(timestamp));
    }

    public void add(int n, Timestamp timestamp) {
        this.values.add(n, new YasonTimestamp(timestamp));
    }

    public YasonValue set(int n, Timestamp timestamp) {
        return this.values.set(n, new YasonTimestamp(timestamp));
    }

    public Timestamp getTimeStamp(int n) {
        return new Timestamp(((Date)((YasonValue)this.values.get(n)).getValue()).getTime());
    }
}

