/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.AbstractYasonValue;
import com.yashandb.json.YasonType;
import java.util.Objects;

public class YasonBoolean
extends AbstractYasonValue {
    public static final YasonBoolean YASON_TRUE = new YasonBoolean(true);
    public static final YasonBoolean YASON_FALSE = new YasonBoolean(false);
    private static final byte[] TRUE_VALUE = new byte[]{5, 1};
    private static final byte[] FALSE_VALUE = new byte[]{5, 0};
    private final boolean value;

    public static YasonBoolean buildYasonValue(byte[] byArray, int n) {
        return byArray[n + 1] == 1 ? YASON_TRUE : YASON_FALSE;
    }

    public YasonBoolean(boolean bl) {
        this.value = bl;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_BOOLEAN;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public static YasonBoolean getInstance(boolean bl) {
        return bl ? YASON_TRUE : YASON_FALSE;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    protected byte[] internalGetBinaryData() {
        return this.value ? TRUE_VALUE : FALSE_VALUE;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonBoolean yasonBoolean = (YasonBoolean)object;
        return this.value == yasonBoolean.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

