/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.AbstractYasonValue;
import com.yashandb.json.YasonType;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.util.ByteConverter;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class YasonDate
extends AbstractYasonValue {
    private final Date value;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static YasonDate buildYasonValue(byte[] byArray, int n) {
        long l = ByteConverter.int8(byArray, n + 1);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        Calendar calendar = Calendar.getInstance();
        YasonDate.checkYear(internalTimeStamp.getYear());
        internalTimeStamp.setValueForCalendar(calendar);
        Date date = new Date(calendar.getTimeInMillis());
        return new YasonDate(date);
    }

    public YasonDate(Date date) {
        YasonDate.checkYear(date);
        this.value = date instanceof java.sql.Date ? new Date(date.getTime()) : date;
    }

    public YasonDate(LocalDate localDate) {
        this(java.sql.Date.valueOf(localDate));
    }

    public YasonDate(LocalDateTime localDateTime) {
        YasonDate.checkYear(localDateTime.getYear());
        this.value = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_DATE;
    }

    @Override
    public Date getValue() {
        return this.value;
    }

    public Date getDate() {
        return this.value;
    }

    public Date dateValue() {
        return this.getDate();
    }

    public LocalDate getLocalDate() {
        return LocalDateTime.ofInstant(this.value.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public LocalDate localDateValue() {
        return this.getLocalDate();
    }

    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.ofInstant(this.value.toInstant(), ZoneId.systemDefault());
    }

    public LocalDateTime localDateTimeValue() {
        return this.getLocalDateTime();
    }

    @Override
    public String getString() {
        return this.simpleDateFormat.format(this.value);
    }

    @Override
    public String toString() {
        return "\"" + this.getString() + "\"";
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[9];
        byArray[0] = (byte)this.getType().getValue();
        long l = this.value.getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setDateAndTime(l);
        long l2 = InternalTimeStamp.transTimeStampToValue(internalTimeStamp);
        ByteConverter.int8(byArray, 1, l2);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonDate yasonDate = (YasonDate)object;
        return Objects.equals(this.value, yasonDate.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

