/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonException;
import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonType;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;

public class YasonDecimal
extends YasonNumber {
    private final BigDecimal value;

    public static YasonDecimal buildYasonValue(byte[] byArray, int n) {
        int n2 = byArray[n + 1] & 0xFF;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n + 2, n + 2 + n2);
        return new YasonDecimal(ByteConverter.toBigDecimal(byArray2, 0));
    }

    public YasonDecimal(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public YasonDecimal(Number number) {
        this.value = new BigDecimal(number.toString());
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_NUMBER;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.value.toPlainString();
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[22];
        byArray[0] = (byte)this.getType().getValue();
        try {
            int n = ByteConverter.bigDecimalToBytes(byArray, 2, this.value);
            byArray[1] = (byte)n;
            byte[] byArray2 = new byte[n + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        catch (SQLException sQLException) {
            throw new YasonException("scale of value Overflow.value:" + this.value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonDecimal yasonDecimal = (YasonDecimal)object;
        return this.value.equals(yasonDecimal.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

