/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonType;
import com.yashandb.util.ByteConverter;
import java.util.Objects;

public class YasonDouble
extends YasonNumber {
    private final double value;

    public static YasonDouble buildYasonValue(byte[] byArray, int n) {
        return new YasonDouble(ByteConverter.float8(byArray, n + 1));
    }

    public YasonDouble(double d) {
        this.value = d;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_DOUBLE;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        if (this.value == Double.POSITIVE_INFINITY) {
            return "\"Inf\"";
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return "\"-Inf\"";
        }
        return Double.isNaN(this.value) ? "\"Nan\"" : Double.toString(this.value);
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[9];
        byArray[0] = (byte)this.getType().getValue();
        ByteConverter.float8(byArray, 1, this.value);
        return byArray;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonDouble yasonDouble = (YasonDouble)object;
        return Double.compare(yasonDouble.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

