/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonException;
import com.yashandb.json.YasonGenerationException;
import com.yashandb.util.Messages;

public abstract class YasonExceptions {
    public static final ExceptionFactory EXCEPTION_FACTORY = new YasonExceptionFactory();
    public static final YasonExceptions IO = YasonExceptions.a("an i/o exception occurred");
    public static final YasonExceptions BAD_YEAR = YasonExceptions.a("the year \"{0}\" is not supported");
    public static final YasonExceptions GENERATION_INCOMPLETE = YasonExceptions.c("generator closed before before end");
    public static final YasonExceptions MISSING_KEY = YasonExceptions.c("an object key must be specified in this context");
    public static final YasonExceptions EXTRA_EVENTS = YasonExceptions.c("invalid write. A complete value has already been written");
    public static final YasonExceptions BAD_END = YasonExceptions.c("end not allowed in this context");
    public static final YasonExceptions BAD_KEY = YasonExceptions.c("key not allowed in this context");
    public static final YasonExceptions EXPECTED_VALUE = YasonExceptions.c("expected value after key");
    public static final YasonExceptions PARSER_EXPECTED_EOF = YasonExceptions.b("Expected EOF token, but got {0}");
    public static final YasonExceptions TOKEN_UNEXPECTED_CHAR = YasonExceptions.b("Unexpected character {0} at line {1}, column {2}");
    public static final YasonExceptions TOKEN_EXPECTED_CHAR = YasonExceptions.b("Unexpected character {0} at line {1}, column {2}. Expected {3}");
    public static final YasonExceptions PARSER_INVALID_TOKEN = YasonExceptions.b("Invalid token {0} at line {1}, column {2}. Expected tokens are: {3}");
    public static final YasonExceptions BAD_PARSER_STATE_VALUE = YasonExceptions.d("parser must be on a value");
    public static final YasonExceptions PARSER_GETSTRING_ERR = YasonExceptions.d("JsonParser#getString() is valid only KEY_NAME, VALUE_STRING, VALUE_NUMBER parser states. But current parser state is {0}");
    public static final YasonExceptions PARSER_ISINTEGRAL_ERR = YasonExceptions.d("JsonParser#isIntegralNumber() is valid only VALUE_NUMBER parser state. But current parser state is {0}");
    public static final YasonExceptions PARSER_GETLONG_ERR = YasonExceptions.d("JsonParser#getLong() is valid only VALUE_NUMBER parser state. But current parser state is {0}");
    public static final YasonExceptions PARSER_GETBIGDECIMAL_ERR = YasonExceptions.d("JsonParser#getBigDecimal() is valid only VALUE_NUMBER parser state. But current parser state is {0}");
    public static final YasonExceptions PARSER_GETARRAY_ERR = YasonExceptions.d("JsonParser#getArray() is valid only for START_ARRAY parser state. But current parser state is {0}");
    public static final YasonExceptions PARSER_GETOBJECT_ERR = YasonExceptions.d("JsonParser#getObject() is valid only for START_OBJECT parser state. But current parser state is {0}");
    private String key;

    private YasonExceptions(String string) {
        this.key = string;
    }

    public abstract RuntimeException create(ExceptionFactory var1, Throwable var2, Object ... var3);

    public abstract RuntimeException create(ExceptionFactory var1, Object ... var2);

    public String getMessage(Object ... objectArray) {
        return Messages.get(this.key, objectArray);
    }

    private static YasonExceptions a(String string) {
        return new YasonExceptions(string){

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray), throwable);
            }

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray));
            }
        };
    }

    private static YasonExceptions b(String string) {
        return new YasonExceptions(string){

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray), throwable);
            }

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return exceptionFactory.createJsonException(this.getMessage(objectArray));
            }
        };
    }

    private static YasonExceptions c(String string) {
        return new YasonExceptions(string){

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return exceptionFactory.createGenerationException(this.getMessage(objectArray), throwable);
            }

            @Override
            public RuntimeException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return exceptionFactory.createGenerationException(this.getMessage(objectArray));
            }
        };
    }

    private static YasonExceptions d(String string) {
        return new YasonExceptions(string){

            @Override
            public IllegalStateException create(ExceptionFactory exceptionFactory, Throwable throwable, Object ... objectArray) {
                return new IllegalStateException(this.getMessage(objectArray), throwable);
            }

            @Override
            public IllegalStateException create(ExceptionFactory exceptionFactory, Object ... objectArray) {
                return new IllegalStateException(this.getMessage(objectArray));
            }
        };
    }

    public static interface ExceptionFactory {
        public RuntimeException createJsonException(String var1, Throwable var2);

        public RuntimeException createJsonException(String var1);

        public RuntimeException createGenerationException(String var1);

        public RuntimeException createGenerationException(String var1, Throwable var2);
    }

    private static final class YasonExceptionFactory
    implements ExceptionFactory {
        private YasonExceptionFactory() {
        }

        @Override
        public RuntimeException createJsonException(String string, Throwable throwable) {
            return new YasonException(string, throwable);
        }

        @Override
        public RuntimeException createJsonException(String string) {
            return new YasonException(string);
        }

        @Override
        public RuntimeException createGenerationException(String string, Throwable throwable) {
            return new YasonGenerationException(string, throwable);
        }

        @Override
        public RuntimeException createGenerationException(String string) {
            return new YasonGenerationException(string);
        }
    }
}

