/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.BufferPoolImpl;
import com.yashandb.json.YasonArray;
import com.yashandb.json.YasonBinary;
import com.yashandb.json.YasonBoolean;
import com.yashandb.json.YasonByte;
import com.yashandb.json.YasonDate;
import com.yashandb.json.YasonDecimal;
import com.yashandb.json.YasonDouble;
import com.yashandb.json.YasonException;
import com.yashandb.json.YasonFloat;
import com.yashandb.json.YasonGenerator;
import com.yashandb.json.YasonInt;
import com.yashandb.json.YasonLong;
import com.yashandb.json.YasonNull;
import com.yashandb.json.YasonObject;
import com.yashandb.json.YasonParser;
import com.yashandb.json.YasonShort;
import com.yashandb.json.YasonString;
import com.yashandb.json.YasonTextGenerator;
import com.yashandb.json.YasonTextParser;
import com.yashandb.json.YasonTime;
import com.yashandb.json.YasonTimestamp;
import com.yashandb.json.YasonValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class YasonFactory {
    private final BufferPoolImpl bufferPool = new BufferPoolImpl();

    public YasonParser createJsonTextParser(InputStream inputStream) throws YasonException {
        return new YasonTextParser(inputStream, this.bufferPool);
    }

    public YasonParser createJsonTextParser(Reader reader) throws YasonException {
        return new YasonTextParser(reader, this.bufferPool);
    }

    public YasonValue createJsonTextValue(InputStream inputStream) throws YasonException {
        YasonValue yasonValue;
        try (YasonParser yasonParser = this.createJsonTextParser(inputStream);){
            yasonParser.next();
            yasonValue = yasonParser.getValue();
        }
        return yasonValue;
    }

    public YasonValue createJsonTextValue(Reader reader) throws YasonException {
        YasonValue yasonValue;
        try (YasonParser yasonParser = this.createJsonTextParser(reader);){
            yasonParser.next();
            yasonValue = yasonParser.getValue();
        }
        return yasonValue;
    }

    public YasonGenerator createJsonTextGenerator(OutputStream outputStream) {
        return new YasonTextGenerator(outputStream);
    }

    public YasonGenerator createJsonTextGenerator(Writer writer) {
        return new YasonTextGenerator(writer);
    }

    public YasonObject createObject() {
        return new YasonObject();
    }

    public YasonArray createArray() {
        return new YasonArray();
    }

    public YasonObject createObject(YasonObject yasonObject) {
        return new YasonObject(yasonObject);
    }

    public YasonArray createArray(YasonArray yasonArray) {
        return new YasonArray(yasonArray);
    }

    public YasonString createString(String string) {
        return new YasonString(string);
    }

    public YasonDecimal createDecimal(Number number) throws YasonException {
        return new YasonDecimal(number);
    }

    public YasonInt createInt(int n) {
        return new YasonInt(n);
    }

    public YasonLong createLong(long l) {
        return new YasonLong(l);
    }

    public YasonShort createShort(short s) {
        return new YasonShort(s);
    }

    public YasonByte createByte(byte by) {
        return new YasonByte(by);
    }

    public YasonFloat createFloat(float f) {
        return new YasonFloat(f);
    }

    public YasonDouble createDouble(double d) {
        return new YasonDouble(d);
    }

    public YasonBinary createBinary(byte[] byArray) {
        return new YasonBinary(byArray);
    }

    public YasonBoolean createBoolean(boolean bl) {
        return bl ? YasonBoolean.YASON_TRUE : YasonBoolean.YASON_FALSE;
    }

    public YasonNull createNull() {
        return YasonNull.INSTANCE;
    }

    public YasonTimestamp createTimestamp(LocalDateTime localDateTime) {
        return new YasonTimestamp(localDateTime);
    }

    public YasonDate createDate(LocalDateTime localDateTime) {
        return new YasonDate(localDateTime);
    }

    public YasonDate createDate(LocalDate localDate) {
        return new YasonDate(localDate);
    }

    public YasonDate createDate(Date date) {
        return new YasonDate(date);
    }

    public YasonTime createTime(Time time) {
        return new YasonTime(time);
    }

    public YasonTime createTime(LocalTime localTime) {
        return new YasonTime(localTime);
    }

    public YasonTimestamp createTimestamp(Timestamp timestamp) {
        return new YasonTimestamp(timestamp);
    }
}

