/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonType;
import com.yashandb.util.ByteConverter;
import java.util.Objects;

public class YasonFloat
extends YasonNumber {
    private final float value;

    public static YasonFloat buildYasonValue(byte[] byArray, int n) {
        return new YasonFloat(ByteConverter.float4(byArray, n + 1));
    }

    public YasonFloat(float f) {
        this.value = f;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_FLOAT;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public String getString() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return "\"Inf\"";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "\"-Inf\"";
        }
        return Float.isNaN(this.value) ? "\"Nan\"" : Float.toString(this.value);
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[5];
        byArray[0] = (byte)this.getType().getValue();
        ByteConverter.float4(byArray, 1, this.value);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonFloat yasonFloat = (YasonFloat)object;
        return Float.compare(yasonFloat.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.value));
    }

    @Override
    public float getFloat() {
        return this.value;
    }
}

