/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonType;
import com.yashandb.util.ByteConverter;
import java.util.Objects;

public class YasonInt
extends YasonNumber {
    private final int value;

    public static YasonInt buildYasonValue(byte[] byArray, int n) {
        return new YasonInt(ByteConverter.int4(byArray, n + 1));
    }

    public YasonInt(int n) {
        this.value = n;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_INT;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[5];
        byArray[0] = (byte)this.getType().getValue();
        ByteConverter.int4(byArray, 1, this.value);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonInt yasonInt = (YasonInt)object;
        return this.value == yasonInt.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

