/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonType;
import com.yashandb.util.ByteConverter;
import java.util.Objects;

public class YasonLong
extends YasonNumber {
    private final long value;

    public static YasonLong buildYasonValue(byte[] byArray, int n) {
        return new YasonLong(ByteConverter.int8(byArray, n + 1));
    }

    public YasonLong(long l) {
        this.value = l;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_BIGINT;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[9];
        byArray[0] = (byte)this.getType().getValue();
        ByteConverter.int8(byArray, 1, this.value);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonLong yasonLong = (YasonLong)object;
        return this.value == yasonLong.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

