/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.json.AbstractYasonValue;
import com.yashandb.json.YasonBinary;
import com.yashandb.json.YasonBoolean;
import com.yashandb.json.YasonByte;
import com.yashandb.json.YasonDate;
import com.yashandb.json.YasonDecimal;
import com.yashandb.json.YasonDouble;
import com.yashandb.json.YasonFloat;
import com.yashandb.json.YasonInt;
import com.yashandb.json.YasonLong;
import com.yashandb.json.YasonNull;
import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonShort;
import com.yashandb.json.YasonString;
import com.yashandb.json.YasonTime;
import com.yashandb.json.YasonTimestamp;
import com.yashandb.json.YasonType;
import com.yashandb.json.YasonValue;
import com.yashandb.protocol.Packet;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class YasonObject
extends AbstractYasonValue
implements Map {
    private final Map value = new TreeMap((string, string2) -> {
        if (string.length() != string2.length()) {
            return string.length() - string2.length();
        }
        return string.compareTo((String)string2);
    });

    @Override
    protected byte[] internalGetBinaryData() throws SQLException {
        if (this.size() > 65535) {
            throw SQLError.createSQLException("The number of elements cannot exceed 65535", YasState.DATA_ERROR);
        }
        int n = 2 + this.value.size() * 4;
        Packet packet = new Packet(n, YASON_CHARSET);
        packet.writeShort(this.value.size());
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n2 = 0;
        for (Map.Entry object2 : this.value.entrySet()) {
            packet.writeInt(n + n2);
            int n3 = 2;
            n2 += n3 + ((String)object2.getKey()).getBytes(StandardCharsets.UTF_8).length;
            byte[] byArray = ((AbstractYasonValue)object2.getValue()).internalGetBinaryData();
            n2 += byArray.length;
            linkedList.add(byArray);
        }
        int n4 = 5 + n + n2;
        if (n4 > 0x2000000) {
            throw SQLError.createSQLException("JSON data size cannot exceed 32M", YasState.DATA_ERROR);
        }
        Packet packet2 = new Packet(n4, YASON_CHARSET);
        packet2.writeByte((byte)this.getType().getValue());
        packet2.writeInt(n + n2);
        packet2.writeBytes(packet.getBuffer(), 0, packet.getPostion());
        for (Map.Entry entry : this.value.entrySet()) {
            byte[] byArray = ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8);
            packet2.writeShort(byArray.length);
            packet2.writeBytes(byArray);
            packet2.writeBytes((byte[])linkedList.remove());
        }
        return packet2.getBuffer();
    }

    public static YasonObject buildYasonValue(byte[] byArray, int n) throws SQLException {
        int n2;
        YasonObject yasonObject = new YasonObject();
        int n3 = ByteConverter.int4(byArray, n + 1);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n + 1 + 4, byArray2, 0, n3);
        int n4 = ByteConverter.uint2(byArray2, 0);
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = ByteConverter.int4(byArray2, 2 + n2 * 4);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n5 = ByteConverter.uint2(byArray2, nArray[n2]);
            int n6 = 2;
            String string = YasonObject.replaceSpecialCharacters(new String(byArray2, nArray[n2] + 2, n5, StandardCharsets.UTF_8));
            int n7 = nArray[n2] + 2 + n5;
            YasonValue yasonValue = AbstractYasonValue.buildYasonValue(byArray2, n7);
            yasonObject.put(string, yasonValue);
        }
        return yasonObject;
    }

    public YasonObject() {
    }

    public YasonObject(YasonObject yasonObject) {
        this.value.putAll(yasonObject);
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_OBJECT;
    }

    @Override
    public Map getValue() {
        return this.value;
    }

    @Override
    public int getDepth(int n) throws SQLException {
        int n2 = n;
        for (YasonValue yasonValue : this.value.values()) {
            n2 = Math.max(n2, ((AbstractYasonValue)yasonValue).getDepth(n + 1));
        }
        if (n2 > 100) {
            throw SQLError.createSQLException("The nesting depth of JSON cannot exceed 100", YasState.DATA_ERROR);
        }
        return n2;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.value.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.value.containsValue(object);
    }

    public YasonValue get(Object object) {
        return (YasonValue)this.value.get(object);
    }

    public YasonValue get(Object object, YasonValue yasonValue) {
        return this.value.getOrDefault(object, yasonValue);
    }

    public YasonValue put(String string, YasonValue yasonValue) {
        return this.value.put(string, yasonValue);
    }

    public YasonValue putNull(String string) {
        return this.value.put(string, YasonNull.INSTANCE);
    }

    public boolean isNull(String string) {
        return ((YasonValue)this.value.get(string)).equals(YasonNull.INSTANCE);
    }

    public YasonValue put(String string, String string2) {
        return this.value.put(string, new YasonString(string2));
    }

    public String getString(String string) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        return yasonValue != null ? yasonValue.getString() : null;
    }

    public String getString(String string, String string2) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        return yasonValue != null ? yasonValue.getString() : string2;
    }

    public YasonValue put(String string, BigDecimal bigDecimal) {
        return this.value.put(string, new YasonDecimal(bigDecimal));
    }

    private YasonNumber a(String string) {
        return (YasonNumber)this.value.get(string);
    }

    protected BigDecimal castToBigDecimal(YasonValue yasonValue) {
        if (yasonValue == null) {
            return null;
        }
        try {
            return ((YasonNumber)yasonValue).getBigDecimal();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal2 != null ? bigDecimal2 : bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        return yasonValue == null ? null : ((YasonNumber)yasonValue).getBigDecimal();
    }

    public YasonValue put(String string, byte by) {
        return this.value.put(string, new YasonByte(by));
    }

    public byte getByte(String string) {
        return this.a(string).byteValue();
    }

    public byte getByte(String string, byte by) {
        BigDecimal bigDecimal = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal != null ? bigDecimal.byteValue() : by;
    }

    public YasonValue put(String string, short s) {
        return this.value.put(string, new YasonShort(s));
    }

    public short getShort(String string) {
        return this.a(string).shortValue();
    }

    public short getShort(String string, short s) {
        BigDecimal bigDecimal = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal != null ? bigDecimal.shortValue() : s;
    }

    public YasonValue put(String string, int n) {
        return this.value.put(string, new YasonInt(n));
    }

    public int getInt(String string) {
        return this.a(string).intValue();
    }

    public int getInt(String string, int n) {
        BigDecimal bigDecimal = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal != null ? bigDecimal.intValue() : n;
    }

    public YasonValue put(String string, long l) {
        return this.value.put(string, new YasonLong(l));
    }

    public long getLong(String string) {
        return this.a(string).longValue();
    }

    public long getLong(String string, long l) {
        BigDecimal bigDecimal = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal != null ? bigDecimal.longValue() : l;
    }

    public YasonValue put(String string, float f) {
        return this.value.put(string, new YasonFloat(f));
    }

    public float getFloat(String string) {
        return this.a(string).floatValue();
    }

    public float getFloat(String string, float f) {
        if (this.get(string) instanceof YasonFloat) {
            return ((YasonFloat)this.get(string)).getFloat();
        }
        BigDecimal bigDecimal = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal != null ? bigDecimal.floatValue() : f;
    }

    public YasonValue put(String string, double d) {
        return this.value.put(string, new YasonDouble(d));
    }

    public double getDouble(String string) {
        return this.a(string).doubleValue();
    }

    public double getDouble(String string, double d) {
        if (this.get(string) instanceof YasonDouble) {
            return ((YasonDouble)this.get(string)).getDouble();
        }
        BigDecimal bigDecimal = this.castToBigDecimal((YasonValue)this.value.get(string));
        return bigDecimal != null ? bigDecimal.doubleValue() : d;
    }

    public YasonValue put(String string, byte[] byArray) {
        return this.value.put(string, new YasonBinary(byArray));
    }

    public byte[] getBytes(String string) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        return ((YasonBinary)yasonValue).getValue();
    }

    public byte[] getBytes(String string, byte[] byArray) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        if (yasonValue instanceof YasonBinary) {
            return ((YasonBinary)yasonValue).getValue();
        }
        return byArray;
    }

    public YasonValue put(String string, Date date) {
        return this.value.put(string, new YasonDate(date));
    }

    public Date getDate(String string) {
        return (Date)((YasonValue)this.value.get(string)).getValue();
    }

    public Date getDate(String string, Date date) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        if (yasonValue == null) {
            return date;
        }
        Object object = yasonValue.getValue();
        if (object instanceof Date) {
            return (Date)object;
        }
        return date;
    }

    public YasonValue put(String string, LocalDate localDate) {
        return this.value.put(string, new YasonDate(localDate));
    }

    public LocalDate getLocalDate(String string) {
        return this.getLocalDateTime(string).toLocalDate();
    }

    public LocalDate getLocalDate(String string, LocalDate localDate) {
        LocalDateTime localDateTime = this.getLocalDateTime(string, null);
        if (localDateTime != null) {
            return localDateTime.toLocalDate();
        }
        return localDate;
    }

    public YasonValue put(String string, LocalTime localTime) {
        return this.value.put(string, new YasonTime(localTime));
    }

    public LocalTime getLocalTime(String string) {
        return this.getLocalDateTime(string).toLocalTime();
    }

    public LocalTime getLocalTime(String string, LocalTime localTime) {
        LocalDateTime localDateTime = this.getLocalDateTime(string, null);
        if (localDateTime != null) {
            return localDateTime.toLocalTime();
        }
        return localTime;
    }

    public YasonValue put(String string, Time time) {
        return this.value.put(string, new YasonTime(time));
    }

    public Time getTime(String string) {
        return new Time(((Date)((YasonValue)this.value.get(string)).getValue()).getTime());
    }

    public Time getTime(String string, Time time) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        if (yasonValue == null) {
            return time;
        }
        Object object = yasonValue.getValue();
        if (!(object instanceof Date)) {
            return time;
        }
        return new Time(((Date)object).getTime());
    }

    public YasonValue put(String string, Timestamp timestamp) {
        return this.value.put(string, new YasonTimestamp(timestamp));
    }

    public Timestamp getTimeStamp(String string) {
        return new Timestamp(((Date)((YasonValue)this.value.get(string)).getValue()).getTime());
    }

    public Timestamp getTimeStamp(String string, Timestamp timestamp) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        if (yasonValue == null) {
            return timestamp;
        }
        Object object = yasonValue.getValue();
        if (!(object instanceof Date)) {
            return timestamp;
        }
        return new Timestamp(((Date)object).getTime());
    }

    public YasonValue put(String string, LocalDateTime localDateTime) {
        return this.value.put(string, new YasonTimestamp(localDateTime));
    }

    public LocalDateTime getLocalDateTime(String string) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(((Date)((YasonValue)this.value.get(string)).getValue()).getTime()), ZoneId.systemDefault());
    }

    public LocalDateTime getLocalDateTime(String string, LocalDateTime localDateTime) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        if (yasonValue == null) {
            return localDateTime;
        }
        Object object = yasonValue.getValue();
        if (!(object instanceof Date)) {
            return localDateTime;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(((Date)object).getTime()), ZoneId.systemDefault());
    }

    public YasonValue put(String string, boolean bl) {
        return this.value.put(string, YasonBoolean.getInstance(bl));
    }

    public boolean getBoolean(String string) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        return ((YasonBoolean)yasonValue).getValue();
    }

    public boolean getBoolean(String string, boolean bl) {
        YasonValue yasonValue = (YasonValue)this.value.get(string);
        if (this.value instanceof YasonBoolean) {
            return ((YasonBoolean)yasonValue).getValue();
        }
        return bl;
    }

    public YasonValue remove(Object object) {
        return (YasonValue)this.value.remove(object);
    }

    public void putAll(Map map) {
        this.value.putAll(map);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    public Set keySet() {
        return this.value.keySet();
    }

    public Collection values() {
        return this.value.values();
    }

    public Set entrySet() {
        return this.value.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonObject yasonObject = (YasonObject)object;
        return this.value.equals(yasonObject.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

