/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonType;
import com.yashandb.util.ByteConverter;
import java.util.Objects;

public class YasonShort
extends YasonNumber {
    private final short value;

    public static YasonShort buildYasonValue(byte[] byArray, int n) {
        return new YasonShort(ByteConverter.int2(byArray, n + 1));
    }

    public YasonShort(short s) {
        this.value = s;
    }

    public YasonShort(int n) {
        this.value = (short)n;
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_SHORT;
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[3];
        byArray[0] = (byte)this.getType().getValue();
        ByteConverter.int2(byArray, 1, this.value);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonShort yasonShort = (YasonShort)object;
        return this.value == yasonShort.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

