/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.AbstractYasonVariableLengthType;
import com.yashandb.json.YasonType;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Objects;

public class YasonString
extends AbstractYasonVariableLengthType {
    private final String value;

    public static YasonString buildYasonValue(byte[] byArray, int n) throws SQLException {
        int n2 = YasonString.getLenByteSize(byArray, ++n);
        int n3 = YasonString.getLen(byArray, n, n2);
        return new YasonString(new String(byArray, n + n2, n3, StandardCharsets.UTF_8));
    }

    public String stringValue() {
        return this.value;
    }

    public YasonString(String string) {
        this.value = string;
    }

    public YasonString(Object object) {
        this(object.toString());
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_STRING;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = this.value.getBytes(StandardCharsets.UTF_8);
        return this.getBinaryData(byArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonString yasonString = (YasonString)object;
        return this.value.equals(yasonString.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return "\"" + YasonString.replaceSpecialCharacters(this.value) + "\"";
    }
}

