/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.StreamContext;
import com.yashandb.json.YasonArray;
import com.yashandb.json.YasonBinary;
import com.yashandb.json.YasonBoolean;
import com.yashandb.json.YasonExceptions;
import com.yashandb.json.YasonGenerator;
import com.yashandb.json.YasonNumber;
import com.yashandb.json.YasonObject;
import com.yashandb.json.YasonTextParser;
import com.yashandb.json.YasonValue;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Map;

public class YasonTextGenerator
implements YasonGenerator {
    private static final int BASIC_CODE = 10;
    private static final int CONTROL_CODE = 1;
    private static final int LINE_FEED_CODE = 2;
    private static final int DOUBLE_QUOTA_CODE = 3;
    private static final int BACKSLASH_CODE = 4;
    private static final int HIGH_SURROGATES_CODE = 5;
    private static final int BACKSPACE_CODE = 6;
    private static final int FORM_FEED_CODE = 7;
    private static final int CARRIAGE_RETURN_CODE = 8;
    private static final int HORIZONTAL_TAB_CODE = 9;
    private static final byte[] CHAR_TYPES;
    private JsonOutput writer;
    private StreamContext ctx;

    public YasonTextGenerator(OutputStream outputStream) {
        this.writer = new UTF8JsonOutput(outputStream);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    public YasonTextGenerator(Writer writer) {
        this.writer = new WriterJsonOutput(writer);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    @Override
    public YasonGenerator writeStartObject() {
        this.c();
        this.ctx.startObject();
        this.a('{');
        return this;
    }

    @Override
    public YasonGenerator writeStartArray() {
        this.c();
        this.ctx.startArray();
        this.a('[');
        return this;
    }

    @Override
    public YasonGenerator writeEnd() {
        if (this.ctx.inObject()) {
            this.ctx.end();
            this.a('}');
        } else {
            this.ctx.end();
            this.a(']');
        }
        return this;
    }

    @Override
    public YasonGenerator write(String string) {
        this.b();
        YasonTextGenerator.a(string, this.writer, this.getExceptionFactory());
        return this;
    }

    @Override
    public YasonGenerator writeKey(String string) {
        this.c();
        this.ctx.pendingKey();
        YasonTextGenerator.a(string, this.writer, this.getExceptionFactory());
        this.a(':');
        return this;
    }

    private static void a(String string, JsonOutput jsonOutput, YasonExceptions.ExceptionFactory exceptionFactory) {
        try {
            jsonOutput.writeAscii((byte)34);
            YasonTextGenerator.a(string, jsonOutput);
            jsonOutput.writeAscii((byte)34);
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(exceptionFactory, iOException, new Object());
        }
    }

    public static String serializeString(String string) {
        StringWriter stringWriter = new StringWriter();
        WriterJsonOutput writerJsonOutput = new WriterJsonOutput(stringWriter);
        YasonTextGenerator.a(string, writerJsonOutput, null);
        try {
            writerJsonOutput.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringWriter.toString();
    }

    @Override
    public YasonGenerator write(Number number) {
        this.b();
        this.a(number);
        return this;
    }

    @Override
    public YasonGenerator write(boolean bl) {
        this.b();
        this.a(bl);
        return this;
    }

    @Override
    public YasonGenerator writeNull() {
        this.b();
        this.a();
        return this;
    }

    @Override
    public void close() {
        this.ctx.close();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object());
        }
    }

    protected YasonExceptions.ExceptionFactory getExceptionFactory() {
        return YasonExceptions.EXCEPTION_FACTORY;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object());
        }
    }

    private YasonGenerator a(YasonNumber yasonNumber) {
        this.b();
        try {
            this.writer.writeAscii(this.b(yasonNumber));
            return this;
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object());
        }
    }

    private String b(YasonNumber yasonNumber) {
        return yasonNumber.toString();
    }

    protected void writeAscii(CharSequence charSequence) {
        try {
            this.writer.writeAscii(charSequence);
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object());
        }
    }

    private void a(Number number) {
        this.writeAscii(number.toString());
    }

    private void a(boolean bl) {
        this.writeAscii(String.valueOf(bl));
    }

    private void a() {
        this.writeAscii("null");
    }

    private void a(char c) {
        try {
            this.writer.writeAscii((byte)c);
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object());
        }
    }

    private void b() {
        this.c();
        this.ctx.primitive();
    }

    private void c() {
        if (this.ctx.hasChildren() && !this.ctx.pendingKey) {
            this.a(',');
        }
    }

    private static void a(String string, JsonOutput jsonOutput) throws IOException {
        int n = string.length();
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (CHAR_TYPES[c]) {
                case 1: {
                    YasonTextGenerator.a(c, jsonOutput);
                    continue block12;
                }
                case 2: {
                    jsonOutput.writeAscii("\\n");
                    continue block12;
                }
                case 3: {
                    jsonOutput.writeAscii("\\\"");
                    continue block12;
                }
                case 4: {
                    jsonOutput.writeAscii("\\\\");
                    continue block12;
                }
                case 5: {
                    jsonOutput.writeSurrogates(string.charAt(i), string.charAt(++i));
                    continue block12;
                }
                case 6: {
                    jsonOutput.writeAscii("\\b");
                    continue block12;
                }
                case 7: {
                    jsonOutput.writeAscii("\\f");
                    continue block12;
                }
                case 8: {
                    jsonOutput.writeAscii("\\r");
                    continue block12;
                }
                case 9: {
                    jsonOutput.writeAscii("\\t");
                    continue block12;
                }
                case 10: {
                    jsonOutput.writeAscii((byte)c);
                    continue block12;
                }
                default: {
                    jsonOutput.write(c);
                }
            }
        }
    }

    private static void a(int n, JsonOutput jsonOutput) throws IOException {
        for (char c : Character.toChars(n)) {
            String string = Integer.toHexString(c).toUpperCase();
            jsonOutput.writeAscii("\\u");
            for (int i = 0; i < 4 - string.length(); ++i) {
                jsonOutput.writeAscii((byte)48);
            }
            jsonOutput.writeAscii(string);
        }
    }

    @Override
    public YasonGenerator write(LocalDateTime localDateTime) {
        this.write(String.valueOf(localDateTime));
        return this;
    }

    @Override
    public YasonGenerator write(String string, LocalDateTime localDateTime) {
        this.writeKey(string);
        this.write(localDateTime);
        return this;
    }

    @Override
    public YasonGenerator write(String string, byte[] byArray) {
        this.writeKey(string);
        this.write(byArray);
        return this;
    }

    @Override
    public YasonGenerator write(byte[] byArray) {
        this.write(new YasonBinary(byArray));
        return this;
    }

    public void writeStringFromParser(YasonTextParser yasonTextParser) {
        this.write(yasonTextParser.getString());
    }

    protected void writeDecimalFromParser(YasonTextParser yasonTextParser) {
        this.b();
        try {
            this.writer.writeAscii(yasonTextParser.getString());
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object());
        }
    }

    private void a(YasonValue yasonValue) {
        switch (yasonValue.getType()) {
            case YASON_OBJECT: {
                YasonObject yasonObject = (YasonObject)yasonValue;
                this.writeStartObject();
                for (Map.Entry entry : yasonObject.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.a((YasonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case YASON_ARRAY: {
                YasonArray yasonArray = (YasonArray)yasonValue;
                this.writeStartArray();
                Iterator iterator = yasonArray.iterator();
                while (iterator.hasNext()) {
                    this.a((YasonValue)iterator.next());
                }
                this.writeEnd();
                break;
            }
            case YASON_FLOAT: 
            case YASON_DOUBLE: 
            case YASON_NUMBER: 
            case YASON_BYTE: 
            case YASON_BIGINT: 
            case YASON_INT: 
            case YASON_SHORT: {
                this.a((YasonNumber)yasonValue);
                break;
            }
            case YASON_BOOLEAN: {
                this.write(yasonValue.equals(YasonBoolean.YASON_TRUE));
                break;
            }
            case YASON_NULL: {
                this.writeNull();
                break;
            }
            case YASON_TIME: 
            case YASON_STRING: 
            case YASON_TIMESTAMP: 
            case YASON_DATE: 
            case YASON_BINARY: {
                this.write(yasonValue.getString());
            }
        }
    }

    @Override
    public YasonGenerator writeParser(Object object) {
        if (object instanceof YasonTextParser) {
            this.a((YasonTextParser)object);
        }
        return this;
    }

    void a(YasonTextParser yasonTextParser) {
        block11: while (yasonTextParser.hasNext()) {
            switch (yasonTextParser.next()) {
                case START_OBJECT: {
                    this.writeStartObject();
                    continue block11;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    continue block11;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    this.writeEnd();
                    continue block11;
                }
                case KEY_NAME: {
                    this.writeKey(yasonTextParser.getString());
                    continue block11;
                }
                case VALUE_STRING: {
                    this.writeStringFromParser(yasonTextParser);
                    continue block11;
                }
                case VALUE_TRUE: {
                    this.write(true);
                    continue block11;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    continue block11;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    continue block11;
                }
                case VALUE_DECIMAL: {
                    this.writeDecimalFromParser(yasonTextParser);
                    continue block11;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public YasonGenerator write(YasonValue yasonValue) {
        this.a(yasonValue);
        return this;
    }

    static {
        int n;
        CHAR_TYPES = new byte[65536];
        for (n = 0; n <= 127; ++n) {
            YasonTextGenerator.CHAR_TYPES[n] = 10;
        }
        for (n = 0; n <= 31; n = (int)((char)(n + 1))) {
            YasonTextGenerator.CHAR_TYPES[n] = 1;
        }
        YasonTextGenerator.CHAR_TYPES[127] = 1;
        YasonTextGenerator.CHAR_TYPES[10] = 2;
        YasonTextGenerator.CHAR_TYPES[92] = 4;
        YasonTextGenerator.CHAR_TYPES[34] = 3;
        YasonTextGenerator.CHAR_TYPES[8] = 6;
        YasonTextGenerator.CHAR_TYPES[12] = 7;
        YasonTextGenerator.CHAR_TYPES[13] = 8;
        YasonTextGenerator.CHAR_TYPES[9] = 9;
        for (n = 55296; n <= 56319; n = (int)((char)(n + 1))) {
            YasonTextGenerator.CHAR_TYPES[n] = 5;
        }
    }

    private static interface JsonOutput
    extends Closeable {
        public void flush() throws IOException;

        public void write(char var1) throws IOException;

        public void writeAscii(CharSequence var1) throws IOException;

        public void writeAscii(byte var1) throws IOException;

        public void writeSurrogates(char var1, char var2) throws IOException;
    }

    private static final class WriterJsonOutput
    implements JsonOutput {
        char[] buffer = new char[1024];
        int pos = 0;
        Writer writer;

        WriterJsonOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.writer.close();
            this.buffer = null;
        }

        @Override
        public void flush() throws IOException {
            this.writer.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void writeAscii(CharSequence charSequence) throws IOException {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = charSequence.charAt(i);
            }
        }

        @Override
        public void writeAscii(byte by) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = (char)by;
        }

        @Override
        public void write(char c) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = c;
        }

        @Override
        public void writeSurrogates(char c, char c2) throws IOException {
            this.write(c);
            this.write(c2);
        }
    }

    private static class UTF8JsonOutput
    implements JsonOutput {
        byte[] buffer = new byte[1024];
        OutputStream out;
        int pos = 0;
        CharsetEncoder encoder;
        CharBuffer cbuffer;

        UTF8JsonOutput(OutputStream outputStream) {
            this.out = outputStream;
        }

        private void a() {
            if (this.encoder == null) {
                this.encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.cbuffer = CharBuffer.allocate(2);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
            this.buffer = null;
        }

        @Override
        public void writeAscii(CharSequence charSequence) throws IOException {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = (byte)charSequence.charAt(i);
            }
        }

        @Override
        public void writeAscii(byte by) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = by;
        }

        @Override
        public void flush() throws IOException {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void write(char c) throws IOException {
            if (c <= '\u007f') {
                this.writeAscii((byte)c);
            } else {
                this.flush();
                this.a();
                this.cbuffer.clear();
                this.cbuffer.append(c);
                this.cbuffer.flip();
                this.b();
            }
        }

        @Override
        public void writeSurrogates(char c, char c2) throws IOException {
            this.flush();
            this.a();
            this.cbuffer.clear();
            this.cbuffer.append(c);
            this.cbuffer.append(c2);
            this.cbuffer.flip();
            this.b();
        }

        private void b() {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer);
            this.encoder.encode(this.cbuffer, byteBuffer, false);
            this.pos = byteBuffer.position();
        }
    }
}

