/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.BufferPoolImpl;
import com.yashandb.json.JsonLocationImpl;
import com.yashandb.json.JsonTokenizer;
import com.yashandb.json.YasonArray;
import com.yashandb.json.YasonBoolean;
import com.yashandb.json.YasonDecimal;
import com.yashandb.json.YasonExceptions;
import com.yashandb.json.YasonNull;
import com.yashandb.json.YasonObject;
import com.yashandb.json.YasonParser;
import com.yashandb.json.YasonString;
import com.yashandb.json.YasonType;
import com.yashandb.json.YasonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;

public class YasonTextParser
implements YasonParser {
    private Context currentContext = new NoneContext();
    private YasonParser.Event currentEvent;
    private final Stack stack = new Stack();
    private final JsonTokenizer tokenizer;

    public YasonTextParser(Reader reader, BufferPoolImpl bufferPoolImpl) {
        this.tokenizer = new JsonTokenizer(reader, bufferPoolImpl);
    }

    public YasonTextParser(InputStream inputStream, BufferPoolImpl bufferPoolImpl) {
        this.tokenizer = new JsonTokenizer(new InputStreamReader(inputStream), bufferPoolImpl);
    }

    private YasonExceptions.ExceptionFactory a() {
        return YasonExceptions.EXCEPTION_FACTORY;
    }

    @Override
    public String getString() {
        if (this.currentEvent != YasonParser.Event.KEY_NAME && this.currentEvent != YasonParser.Event.VALUE_STRING && this.currentEvent != YasonParser.Event.VALUE_DECIMAL) {
            throw YasonExceptions.PARSER_GETSTRING_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.e();
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.currentEvent != YasonParser.Event.VALUE_DECIMAL) {
            throw YasonExceptions.PARSER_ISINTEGRAL_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.i();
    }

    @Override
    public int getInt() {
        if (this.currentEvent != YasonParser.Event.VALUE_DECIMAL) {
            throw YasonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.g();
    }

    @Override
    public double getDouble() {
        return this.getBigDecimal().doubleValue();
    }

    @Override
    public float getFloat() {
        return this.getBigDecimal().floatValue();
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    @Override
    public long getLong() {
        if (this.currentEvent != YasonParser.Event.VALUE_DECIMAL) {
            throw YasonExceptions.PARSER_GETLONG_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.h();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.currentEvent != YasonParser.Event.VALUE_DECIMAL) {
            throw YasonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.f();
    }

    @Override
    public YasonArray getArray() {
        if (this.currentEvent != YasonParser.Event.START_ARRAY) {
            throw YasonExceptions.PARSER_GETARRAY_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return (YasonArray)this.getValue();
    }

    @Override
    public YasonObject getObject() {
        if (this.currentEvent != YasonParser.Event.START_OBJECT) {
            throw YasonExceptions.PARSER_GETOBJECT_ERR.create(this.a(), new Object[]{this.currentEvent});
        }
        return (YasonObject)this.getValue();
    }

    @Override
    public YasonValue getValue() {
        ArrayDeque<YasonBoolean> arrayDeque = new ArrayDeque<YasonBoolean>(4);
        String string = null;
        if (this.currentEvent != null && this.currentEvent != YasonParser.Event.END_ARRAY && this.currentEvent != YasonParser.Event.END_OBJECT) {
            block11: while (true) {
                YasonValue yasonValue;
                switch (this.currentEvent) {
                    case END_ARRAY: 
                    case END_OBJECT: {
                        yasonValue = (YasonValue)arrayDeque.pop();
                        break;
                    }
                    case KEY_NAME: {
                        string = this.getString();
                        this.next();
                        continue block11;
                    }
                    case START_ARRAY: {
                        yasonValue = new YasonArray();
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        arrayDeque.push((YasonBoolean)yasonValue);
                        break;
                    }
                    case START_OBJECT: {
                        yasonValue = new YasonObject();
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        arrayDeque.push((YasonBoolean)yasonValue);
                        break;
                    }
                    case VALUE_DECIMAL: {
                        yasonValue = new YasonDecimal(this.getBigDecimal());
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        break;
                    }
                    case VALUE_STRING: {
                        yasonValue = new YasonString(this.getString());
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        break;
                    }
                    case VALUE_TRUE: {
                        yasonValue = YasonBoolean.YASON_TRUE;
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        break;
                    }
                    case VALUE_FALSE: {
                        yasonValue = YasonBoolean.YASON_FALSE;
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        break;
                    }
                    case VALUE_NULL: {
                        yasonValue = YasonNull.INSTANCE;
                        YasonTextParser.a(yasonValue, arrayDeque, string);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                string = null;
                if (arrayDeque.isEmpty()) {
                    return yasonValue;
                }
                this.next();
            }
        }
        throw YasonExceptions.BAD_PARSER_STATE_VALUE.create(this.a(), new Object());
    }

    private static void a(YasonValue yasonValue, ArrayDeque arrayDeque, String string) {
        if (!arrayDeque.isEmpty()) {
            YasonValue yasonValue2 = (YasonValue)arrayDeque.peek();
            if (yasonValue2.getType() == YasonType.YASON_OBJECT) {
                ((YasonObject)yasonValue2).put(string, yasonValue);
            } else {
                ((YasonArray)yasonValue2).add(yasonValue);
            }
        }
    }

    @Override
    public void skipArray() {
        if (this.currentEvent == YasonParser.Event.START_ARRAY) {
            this.currentContext.a();
            this.currentContext = this.stack.a();
            this.currentEvent = YasonParser.Event.END_ARRAY;
        }
    }

    @Override
    public void skipObject() {
        if (this.currentEvent == YasonParser.Event.START_OBJECT) {
            this.currentContext.a();
            this.currentContext = this.stack.a();
            this.currentEvent = YasonParser.Event.END_OBJECT;
        }
    }

    public JsonLocationImpl getLocation() {
        return this.tokenizer.d();
    }

    public JsonLocationImpl getLastCharLocation() {
        return this.tokenizer.c();
    }

    @Override
    public boolean hasNext() {
        if (this.stack.b() && this.currentEvent != null && this.currentEvent.compareTo(YasonParser.Event.KEY_NAME) > 0) {
            JsonTokenizer.JsonToken jsonToken = this.tokenizer.a();
            if (jsonToken != JsonTokenizer.JsonToken.EOF) {
                throw YasonExceptions.PARSER_EXPECTED_EOF.create(this.a(), new Object[]{this.currentEvent});
            }
            return false;
        }
        if (!this.stack.b() && !this.tokenizer.b()) {
            this.currentEvent = this.currentContext.getNextEvent();
            return false;
        }
        return true;
    }

    @Override
    public YasonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEvent = this.currentContext.getNextEvent();
        return this.currentEvent;
    }

    @Override
    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException iOException) {
            throw YasonExceptions.IO.create(this.a(), new Object[]{this.currentEvent});
        }
    }

    private RuntimeException a(JsonTokenizer.JsonToken jsonToken, String string) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return YasonExceptions.PARSER_INVALID_TOKEN.create(this.a(), new Object[]{jsonToken, jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber(), string});
    }

    private static final class Stack {
        private Context head;

        private Stack() {
        }

        private void a(Context context) {
            context.next = this.head;
            this.head = context;
        }

        private Context a() {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            Context context = this.head;
            this.head = this.head.next;
            return context;
        }

        private boolean b() {
            return this.head == null;
        }
    }

    private abstract class Context {
        Context next;

        private Context() {
        }

        abstract YasonParser.Event getNextEvent();

        abstract void a();

        protected YasonParser.Event getEvent(JsonTokenizer.JsonToken jsonToken) {
            if (jsonToken.b()) {
                return jsonToken.a();
            }
            if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                YasonTextParser.this.stack.a(YasonTextParser.this.currentContext);
                YasonTextParser yasonTextParser = YasonTextParser.this;
                yasonTextParser.getClass();
                YasonTextParser.this.currentContext = yasonTextParser.new ObjectContext();
                return YasonParser.Event.START_OBJECT;
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                YasonTextParser.this.stack.a(YasonTextParser.this.currentContext);
                YasonTextParser yasonTextParser = YasonTextParser.this;
                yasonTextParser.getClass();
                YasonTextParser.this.currentContext = yasonTextParser.new ArrayContext();
                return YasonParser.Event.START_ARRAY;
            }
            throw YasonTextParser.this.a(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }
    }

    private final class NoneContext
    extends Context {
        private NoneContext() {
        }

        @Override
        public YasonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = YasonTextParser.this.tokenizer.a();
            return this.getEvent(jsonToken);
        }

        @Override
        void a() {
        }
    }

    private final class ObjectContext
    extends Context {
        private boolean firstValue = true;

        private ObjectContext() {
        }

        @Override
        public YasonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = YasonTextParser.this.tokenizer.a();
            if (jsonToken == JsonTokenizer.JsonToken.EOF) {
                switch (YasonTextParser.this.currentEvent) {
                    case KEY_NAME: {
                        throw YasonTextParser.this.a(jsonToken, "[COLON]");
                    }
                    case START_OBJECT: {
                        throw YasonTextParser.this.a(jsonToken, "[STRING, CURLYCLOSE]");
                    }
                }
                throw YasonTextParser.this.a(jsonToken, "[COMMA, CURLYCLOSE]");
            }
            if (YasonTextParser.this.currentEvent == YasonParser.Event.KEY_NAME) {
                return this.a(jsonToken);
            }
            if (jsonToken == JsonTokenizer.JsonToken.CURLYCLOSE) {
                YasonTextParser.this.currentContext = YasonTextParser.this.stack.a();
                return YasonParser.Event.END_OBJECT;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (jsonToken != JsonTokenizer.JsonToken.COMMA) {
                    throw YasonTextParser.this.a(jsonToken, "[COMMA]");
                }
                jsonToken = YasonTextParser.this.tokenizer.a();
            }
            if (jsonToken == JsonTokenizer.JsonToken.STRING) {
                return YasonParser.Event.KEY_NAME;
            }
            throw YasonTextParser.this.a(jsonToken, "[STRING]");
        }

        private YasonParser.Event a(JsonTokenizer.JsonToken jsonToken) {
            if (jsonToken != JsonTokenizer.JsonToken.COLON) {
                throw YasonTextParser.this.a(jsonToken, "[COLON]");
            }
            jsonToken = YasonTextParser.this.tokenizer.a();
            return this.getEvent(jsonToken);
        }

        @Override
        void a() {
            JsonTokenizer.JsonToken jsonToken;
            int n = 1;
            do {
                jsonToken = YasonTextParser.this.tokenizer.a();
                switch (jsonToken) {
                    case CURLYCLOSE: {
                        --n;
                        break;
                    }
                    case CURLYOPEN: {
                        ++n;
                        break;
                    }
                }
            } while (jsonToken != JsonTokenizer.JsonToken.CURLYCLOSE || n != 0);
        }
    }

    private final class ArrayContext
    extends Context {
        private boolean firstValue = true;

        private ArrayContext() {
        }

        @Override
        public YasonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = YasonTextParser.this.tokenizer.a();
            if (jsonToken == JsonTokenizer.JsonToken.EOF) {
                String string = "[COMMA, CURLYCLOSE]";
                if (YasonTextParser.this.currentEvent == YasonParser.Event.START_ARRAY) {
                    string = "[CURLYOPEN, SQUAREOPEN, STRING,NUMBER, TRUE, FALSE, NULL]";
                }
                throw YasonTextParser.this.a(jsonToken, string);
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUARECLOSE) {
                YasonTextParser.this.currentContext = YasonTextParser.this.stack.a();
                return YasonParser.Event.END_ARRAY;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (jsonToken != JsonTokenizer.JsonToken.COMMA) {
                    throw YasonTextParser.this.a(jsonToken, "[COMMA]");
                }
                jsonToken = YasonTextParser.this.tokenizer.a();
            }
            return this.getEvent(jsonToken);
        }

        @Override
        void a() {
            JsonTokenizer.JsonToken jsonToken;
            int n = 1;
            do {
                jsonToken = YasonTextParser.this.tokenizer.a();
                switch (jsonToken) {
                    case SQUARECLOSE: {
                        --n;
                        break;
                    }
                    case SQUAREOPEN: {
                        ++n;
                        break;
                    }
                }
            } while (jsonToken != JsonTokenizer.JsonToken.SQUARECLOSE || n != 0);
        }
    }
}

