/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.AbstractYasonValue;
import com.yashandb.json.YasonType;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.YasTime;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Objects;

public class YasonTime
extends AbstractYasonValue {
    private final YasTime value;
    private final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

    public static YasonTime buildYasonValue(byte[] byArray, int n) {
        long l = ByteConverter.int8(byArray, n + 1);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        Calendar calendar = Calendar.getInstance();
        internalTimeStamp.setValueForCalendar(calendar);
        YasTime yasTime = new YasTime(calendar.getTimeInMillis());
        yasTime.setNanos(internalTimeStamp.getFraction() * 1000);
        return new YasonTime(yasTime);
    }

    public YasonTime(Time time) {
        this.value = new YasTime(time.getTime());
    }

    private YasonTime(YasTime yasTime) {
        this.value = yasTime;
    }

    public YasonTime(LocalTime localTime) {
        this.value = YasTime.valueOf(localTime);
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_TIME;
    }

    @Override
    public Time getValue() {
        return this.value;
    }

    public Time getTime() {
        return this.value;
    }

    public Time timeValue() {
        return this.value;
    }

    public LocalTime getLocalTime() {
        return this.value.toLocalTime();
    }

    public LocalTime localTimeValue() {
        return this.getLocalTime();
    }

    @Override
    public String getString() {
        int n = this.value.getNanos();
        if (n >= 999999500) {
            LocalTime localTime = this.getLocalTime();
            localTime = localTime.plusSeconds(1L);
            return localTime.getHour() + ":" + localTime.getMinute() + ":" + localTime.getSecond();
        }
        return this.sdf.format(this.value) + (n == 0 ? "" : "." + this.getNanoStr(n));
    }

    @Override
    public String toString() {
        return "\"" + this.getString() + "\"";
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[9];
        byArray[0] = (byte)this.getType().getValue();
        long l = this.value.getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setTime(l);
        internalTimeStamp.setFraction(this.value.getNanos() / 1000);
        long l2 = InternalTimeStamp.transTimeToValue(internalTimeStamp);
        ByteConverter.int8(byArray, 1, l2);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonTime yasonTime = (YasonTime)object;
        return this.value.equals(yasonTime.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

