/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.json;

import com.yashandb.json.AbstractYasonValue;
import com.yashandb.json.YasonType;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.util.ByteConverter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Objects;

public class YasonTimestamp
extends AbstractYasonValue {
    private final Timestamp value;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static YasonTimestamp buildYasonValue(byte[] byArray, int n) {
        long l = ByteConverter.int8(byArray, n + 1);
        Calendar calendar = Calendar.getInstance();
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        YasonTimestamp.checkYear(internalTimeStamp.getYear());
        internalTimeStamp.setValueForCalendar(calendar);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(internalTimeStamp.getFraction() * 1000);
        return new YasonTimestamp(timestamp);
    }

    public YasonTimestamp(Timestamp timestamp) {
        YasonTimestamp.checkYear(timestamp);
        this.value = timestamp;
    }

    public YasonTimestamp(LocalDateTime localDateTime) {
        YasonTimestamp.checkYear(localDateTime.getYear());
        this.value = Timestamp.valueOf(localDateTime);
    }

    @Override
    public YasonType getType() {
        return YasonType.YASON_TIMESTAMP;
    }

    @Override
    public Timestamp getValue() {
        return this.value;
    }

    public LocalDateTime localDateTimeValue() {
        return this.getLocalDateTime();
    }

    public LocalDateTime getLocalDateTime() {
        return this.value.toLocalDateTime();
    }

    public Timestamp getTimestamp() {
        return this.value;
    }

    public Timestamp timestampValue() {
        return this.value;
    }

    @Override
    public String getString() {
        int n = this.value.getNanos();
        if (n >= 999999500) {
            LocalDateTime localDateTime = this.getLocalDateTime();
            localDateTime = localDateTime.plusSeconds(1L).withNano(0);
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localDateTime);
        }
        return this.sdf.format(this.value) + (n == 0 ? "" : "." + this.getNanoStr(n));
    }

    @Override
    public String toString() {
        return "\"" + this.getString() + "\"";
    }

    @Override
    protected byte[] internalGetBinaryData() {
        byte[] byArray = new byte[9];
        byArray[0] = (byte)this.getType().getValue();
        long l = this.value.getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setDateAndTime(l);
        internalTimeStamp.setFraction(this.value.getNanos() / 1000);
        long l2 = InternalTimeStamp.transTimeStampToValue(internalTimeStamp);
        ByteConverter.int8(byArray, 1, l2);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        YasonTimestamp yasonTimestamp = (YasonTimestamp)object;
        return this.value.equals(yasonTimestamp.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

