/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.log;

import com.yashandb.log.ILogFactory;
import com.yashandb.log.JDKLoggerFactory;
import com.yashandb.log.Logger;
import com.yashandb.log.SLF4JLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LoggerFactory {
    static ILogFactory iLogFactory;
    static boolean hasSlf4jLog;
    static ConcurrentMap loggerMap;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class clazz) {
        if (clazz == null) {
            return LoggerFactory.getLogger("");
        }
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String string) {
        Logger logger = (Logger)loggerMap.get(string);
        if (logger == null) {
            logger = iLogFactory.getLogger(string);
            loggerMap.putIfAbsent(string, logger);
        }
        return logger;
    }

    public static String getLoggerType() {
        return iLogFactory.getLoggerType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        hasSlf4jLog = false;
        loggerMap = new ConcurrentHashMap();
        String string = "";
        Class<LoggerFactory> clazz = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            try {
                Class.forName("org.slf4j.LoggerFactory");
                hasSlf4jLog = true;
                iLogFactory = new SLF4JLoggerFactory();
            }
            catch (ClassNotFoundException classNotFoundException) {
                hasSlf4jLog = false;
                string = "Can't find org.slf4j.LoggerFactory,use JDK Logger.";
            }
            if (iLogFactory == null) {
                iLogFactory = new JDKLoggerFactory();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LoggerFactory.getLogger(LoggerFactory.class).debug("{} Logger type is {}.", string, LoggerFactory.getLoggerType());
            return;
        }
    }
}

