/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.log;

public interface LoggerHelper {
    public static final String BRACE_STR = "{}";

    public static String format(String string, Object object) {
        return LoggerHelper.arrayFormat(string, new Object[]{object});
    }

    public static String arrayFormat(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return string;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = string.indexOf(BRACE_STR, n);
            if (n2 == -1) {
                if (n == 0) {
                    return string;
                }
                stringBuilder.append(string, n, string.length());
                return stringBuilder.toString();
            }
            stringBuilder.append(string, n, n2);
            LoggerHelper.deeplyAppendParameter(stringBuilder, objectArray[i]);
            n = n2 + 2;
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public static void deeplyAppendParameter(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            LoggerHelper.safeObjectAppend(stringBuilder, object);
        }
    }

    public static void safeObjectAppend(StringBuilder stringBuilder, Object object) {
        try {
            String string = String.valueOf(object);
            stringBuilder.append(string);
        }
        catch (Throwable throwable) {
            stringBuilder.append("Logger: Failed toString() invocation on an object of type [" + object.getClass().getName() + "]");
            stringBuilder.append("[FAILED toString()]");
        }
    }
}

