/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.Packet;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberParameter
extends YasParameter {
    public NumberParameter() {
        this.type = 12;
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof BigDecimal)) {
            this.value = object;
            return;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        bigDecimal = ByteConverter.adjustNumber(bigDecimal);
        this.value = bigDecimal;
    }

    @Override
    public int processWrite(Packet packet) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.value;
        byte[] byArray = new byte[18];
        int n = ByteConverter.bigDecimalToBytes(byArray, 0, bigDecimal);
        packet.writeByte((byte)n);
        packet.writeBytes(byArray, 0, n);
        ByteConverter.toBigDecimal(byArray, 0);
        return n;
    }

    @Override
    public int getParamLength() throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.value;
        byte[] byArray = new byte[18];
        return ByteConverter.bigDecimalToBytes(byArray, 0, bigDecimal) + 1;
    }
}

