/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.parameter.BigIntParameter;
import com.yashandb.parameter.BitParameter;
import com.yashandb.parameter.BlobParameter;
import com.yashandb.parameter.BooleanParameter;
import com.yashandb.parameter.ClobParameter;
import com.yashandb.parameter.DateParameter;
import com.yashandb.parameter.DoubleParameter;
import com.yashandb.parameter.DsIntervalParameter;
import com.yashandb.parameter.FloatParameter;
import com.yashandb.parameter.IntegerParameter;
import com.yashandb.parameter.NumberParameter;
import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.RawParameter;
import com.yashandb.parameter.RowIdParameter;
import com.yashandb.parameter.SmallIntParameter;
import com.yashandb.parameter.StreamParameter;
import com.yashandb.parameter.TimeParameter;
import com.yashandb.parameter.TimeStampParameter;
import com.yashandb.parameter.TinyIntParameter;
import com.yashandb.parameter.VarcharParameter;
import com.yashandb.parameter.YasParameter;
import com.yashandb.parameter.YmIntervalParameter;
import java.sql.SQLException;

public class ParameterLittleEndianFactory
extends ParameterFactory {
    @Override
    public YasParameter getParameter(int n) throws SQLException {
        YasParameter yasParameter;
        switch (n) {
            case 1: {
                yasParameter = new BooleanParameter();
                break;
            }
            case 31: {
                yasParameter = new BitParameter();
                break;
            }
            case 2: {
                yasParameter = new TinyIntParameter();
                break;
            }
            case 3: {
                yasParameter = new SmallIntParameter();
                break;
            }
            case 4: {
                yasParameter = new IntegerParameter();
                break;
            }
            case 5: {
                yasParameter = new BigIntParameter();
                break;
            }
            case 0: 
            case 24: 
            case 26: 
            case 39: {
                yasParameter = new VarcharParameter();
                break;
            }
            case 25: 
            case 27: {
                yasParameter = new VarcharParameter();
                yasParameter.setType(27);
                break;
            }
            case 11: {
                yasParameter = new DoubleParameter();
                break;
            }
            case 10: 
            case 40: {
                yasParameter = new FloatParameter();
                break;
            }
            case 12: {
                yasParameter = new NumberParameter();
                break;
            }
            case 13: {
                yasParameter = new DateParameter();
                break;
            }
            case 16: {
                yasParameter = new TimeStampParameter();
                break;
            }
            case 15: {
                yasParameter = new TimeParameter();
                break;
            }
            case 20: {
                yasParameter = new DsIntervalParameter();
                break;
            }
            case 19: {
                yasParameter = new YmIntervalParameter();
                break;
            }
            case 32: {
                yasParameter = new RowIdParameter();
                break;
            }
            case 28: {
                yasParameter = new RawParameter();
                break;
            }
            case 34: {
                yasParameter = new SmallIntParameter();
                break;
            }
            case 29: 
            case 33: {
                yasParameter = new ClobParameter();
                break;
            }
            case 30: 
            case 35: {
                yasParameter = new BlobParameter(n);
                break;
            }
            case -2: {
                yasParameter = new StreamParameter();
                yasParameter.setType(-2);
                break;
            }
            case -1: {
                yasParameter = new StreamParameter();
                yasParameter.setType(-1);
                break;
            }
            case -3: {
                yasParameter = new StreamParameter();
                yasParameter.setType(-3);
                break;
            }
            case 37: {
                yasParameter = new StreamParameter();
                yasParameter.setType(37);
                break;
            }
            case 36: {
                yasParameter = new StreamParameter();
                yasParameter.setType(36);
                break;
            }
            default: {
                throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), " Bind Type " + DataType.getTypeName(n));
            }
        }
        return yasParameter;
    }
}

