/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.Packet;
import com.yashandb.util.YasTime;
import java.sql.Time;

public class TimeParameter
extends YasParameter {
    private static final int TIME_PARAM_LEN = 9;

    public TimeParameter() {
        this.type = 15;
    }

    @Override
    protected int processWrite(Packet packet) {
        packet.writeByte((byte)8);
        long l = (Long)this.value;
        packet.writeLong(l);
        return 8;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.value = ParameterFactory.getNullObject();
            return;
        }
        if (object == ParameterFactory.getNullObject()) {
            this.value = object;
            return;
        }
        long l = ((Time)object).getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setTime(l);
        if (object instanceof YasTime) {
            internalTimeStamp.setFraction(((YasTime)object).getNanos() / 1000);
        }
        this.value = InternalTimeStamp.transTimeToValue(internalTimeStamp);
    }

    @Override
    protected int getParamLength() {
        return 9;
    }
}

