/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.Packet;
import java.sql.Timestamp;

public class TimeStampParameter
extends YasParameter {
    private static final int TIMESTAMP_PARAM_LEN = 12;

    public TimeStampParameter() {
        this.type = 16;
    }

    @Override
    protected int processWrite(Packet packet) {
        packet.writeByte((byte)12);
        long l = (Long)this.value;
        packet.writeLong(l);
        packet.writeShort(0);
        packet.writeShort(0);
        return 12;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.value = ParameterFactory.getNullObject();
            return;
        }
        if (object == ParameterFactory.getNullObject()) {
            this.value = object;
            return;
        }
        long l = ((Timestamp)object).getTime();
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.setDateAndTime(l);
        internalTimeStamp.setFraction(((Timestamp)object).getNanos() / 1000);
        this.value = InternalTimeStamp.transTimeStampToValue(internalTimeStamp);
    }

    @Override
    protected int getParamLength() {
        return 13;
    }
}

