/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.protocol.Buffer;
import com.yashandb.util.ByteConverter;
import java.nio.charset.Charset;

public abstract class BaseBuffer
implements Buffer {
    private byte[] buffer;
    protected int position = 0;
    private int capacity;
    private Charset charset;

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getPostion() {
        return this.position;
    }

    @Override
    public int getRemainSize() {
        return this.capacity - this.position;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void writeFixString(String string, int n) {
        this.ensureCapacity(n);
        byte[] byArray = this.buffer;
        System.arraycopy(string.getBytes(this.charset), 0, byArray, this.position, string.getBytes(this.charset).length);
        this.position += n;
    }

    @Override
    public void writeString(String string) {
        byte[] byArray = string.getBytes(this.charset);
        this.ensureCapacity(byArray.length);
        byte[] byArray2 = this.buffer;
        System.arraycopy(byArray, 0, byArray2, this.position, byArray.length);
        this.position += byArray.length;
    }

    @Override
    public void writeStringWithByteLength(String string) {
        byte[] byArray = string.getBytes(this.charset);
        this.writeByte((byte)byArray.length);
        this.ensureCapacity(byArray.length);
        byte[] byArray2 = this.buffer;
        System.arraycopy(byArray, 0, byArray2, this.position, byArray.length);
        this.position += byArray.length;
    }

    @Override
    public void writeLong(long l) {
        this.ensureCapacity(8);
        ByteConverter.int8(this.buffer, this.position, l);
        this.position += 8;
    }

    @Override
    public void writeInt(int n) {
        this.ensureCapacity(4);
        ByteConverter.int4(this.buffer, this.position, n);
        this.position += 4;
    }

    @Override
    public void writeShort(int n) {
        this.ensureCapacity(2);
        this.writeShort(this.position, n);
        this.position += 2;
    }

    @Override
    public void writeByte(byte by) {
        this.ensureCapacity(1);
        this.buffer[this.position++] = by;
    }

    @Override
    public void writeFloat(float f) {
        this.ensureCapacity(4);
        this.writeFloat(this.position, f);
        this.position += 4;
    }

    @Override
    public void writeDouble(double d) {
        this.ensureCapacity(8);
        this.writeDouble(this.position, d);
        this.position += 8;
    }

    @Override
    public void writeBytes(byte[] byArray) {
        this.ensureCapacity(byArray.length);
        byte[] byArray2 = this.buffer;
        System.arraycopy(byArray, 0, byArray2, this.position, byArray.length);
        this.position += byArray.length;
    }

    @Override
    public byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, this.position, byArray, 0, n);
        this.position += n;
        return byArray;
    }

    public byte[] getBytes(int n, byte[] byArray) {
        byte[] byArray2 = byArray;
        System.arraycopy(this.buffer, this.position, byArray2, 0, n);
        this.position += n;
        return byArray2;
    }

    @Override
    public int getInt() {
        int n = this.position;
        this.position += 4;
        return this.getInt(n);
    }

    @Override
    public long getLong() {
        int n = this.position;
        this.position += 8;
        return this.getLong(n);
    }

    @Override
    public String getString(int n) {
        int n2 = this.position;
        this.position += n;
        return this.getString(n2, n);
    }

    @Override
    public short getShort() {
        int n = this.position;
        this.position += 2;
        return this.getShort(n);
    }

    @Override
    public byte getByte() {
        int n = this.position++;
        return this.getByte(n);
    }

    @Override
    public void skip(int n) {
        this.position += n;
    }

    @Override
    public void clean() {
        this.position = 8;
    }

    public final void ensureCapacity(int n) {
        if (this.position + n > this.buffer.length) {
            throw new OutOfMemoryError("pos out message capcity");
        }
    }

    protected BaseBuffer(int n) {
        this.capacity = n;
        this.buffer = new byte[n];
    }

    protected BaseBuffer(Buffer buffer) {
        this.buffer = buffer.getBuffer();
        this.capacity = buffer.getCapacity();
    }

    protected int getInt(int n) {
        return ByteConverter.int4(this.buffer, n);
    }

    protected long getLong(int n) {
        return ByteConverter.int8(this.buffer, n);
    }

    protected String getString(int n, int n2) {
        if (this.charset == null) {
            return new String(this.buffer, n, n2);
        }
        return new String(this.buffer, n, n2, this.charset);
    }

    protected byte getByte(int n) {
        return this.buffer[n];
    }

    protected short getShort(int n) {
        return ByteConverter.int2(this.buffer, n);
    }

    protected void writeShort(int n, int n2) {
        ByteConverter.int2(this.buffer, n, n2);
    }

    protected void writeByte(int n, byte by) {
        this.buffer[n] = by;
    }

    protected void writeFloat(int n, float f) {
        ByteConverter.float4(this.buffer, n, f);
    }

    protected void writeDouble(int n, double d) {
        ByteConverter.float8(this.buffer, n, d);
    }

    protected void writeInt(int n, int n2) {
        ByteConverter.int4(this.buffer, n, n2);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2);
        byte[] byArray2 = this.buffer;
        System.arraycopy(byArray, n, byArray2, this.position, n2);
        this.position += n2;
    }

    protected void setPostion(int n) {
        this.position = n;
        if (this.position > this.capacity) {
            throw new OutOfMemoryError("pos out message capcity");
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

