/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.jdbc.YasConnection;
import com.yashandb.protocol.accessor.Accessor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassInstanceConverter {
    private static final Map CLASS_INSTANCE_CONV_MAP = new HashMap();

    private ClassInstanceConverter() {
    }

    public static ClassInstanceConverter getClassConverter(Class clazz) {
        return (ClassInstanceConverter)CLASS_INSTANCE_CONV_MAP.get(clazz);
    }

    public abstract Object redirect(Accessor var1, byte[] var2, YasConnection var3) throws SQLException;

    static {
        CLASS_INSTANCE_CONV_MAP.put(LocalDateTime.class, new ClassInstanceConverter(){

            @Override
            public LocalDateTime redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getLocalDateTime(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(LocalDate.class, new ClassInstanceConverter(){

            @Override
            public LocalDate redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getLocalDate(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(LocalTime.class, new ClassInstanceConverter(){

            @Override
            public LocalTime redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getLocalTime(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(OffsetDateTime.class, new ClassInstanceConverter(){

            @Override
            public OffsetDateTime redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getOffsetDateTime(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(OffsetTime.class, new ClassInstanceConverter(){

            @Override
            public OffsetTime redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getOffsetTime(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(ZonedDateTime.class, new ClassInstanceConverter(){

            @Override
            public ZonedDateTime redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getZonedDateTime(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Date.class, new ClassInstanceConverter(){

            @Override
            public Date redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getDate(byArray, null);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Timestamp.class, new ClassInstanceConverter(){

            @Override
            public Timestamp redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getTimestamp(byArray, null);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Time.class, new ClassInstanceConverter(){

            @Override
            public Time redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getTime(byArray, null);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(java.util.Date.class, new ClassInstanceConverter(){

            @Override
            public java.util.Date redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getJavaUtilDate(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Calendar.class, new ClassInstanceConverter(){

            @Override
            public Calendar redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getCalendar(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Double.class, new ClassInstanceConverter(){

            @Override
            public Double redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getDouble(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Float.class, new ClassInstanceConverter(){

            @Override
            public Float redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return Float.valueOf(accessor.getFloat(byArray));
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Long.class, new ClassInstanceConverter(){

            @Override
            public Long redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getLong(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Integer.class, new ClassInstanceConverter(){

            @Override
            public Integer redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getInt(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Short.class, new ClassInstanceConverter(){

            @Override
            public Short redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getShort(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Byte.class, new ClassInstanceConverter(){

            @Override
            public Byte redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getByte(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Boolean.class, new ClassInstanceConverter(){

            @Override
            public Boolean redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getBoolean(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(BigDecimal.class, new ClassInstanceConverter(){

            @Override
            public BigDecimal redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getBigDecimal(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(String.class, new ClassInstanceConverter(){

            @Override
            public String redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getString(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Reader.class, new ClassInstanceConverter(){

            @Override
            public Reader redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getCharacterStream(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(InputStream.class, new ClassInstanceConverter(){

            @Override
            public InputStream redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getBinaryStream(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(BigInteger.class, new ClassInstanceConverter(){

            @Override
            public BigInteger redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getBigInteger(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(byte[].class, new ClassInstanceConverter(){

            public byte[] redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getBytes(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(RowId.class, new ClassInstanceConverter(){

            @Override
            public RowId redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getRowId(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Period.class, new ClassInstanceConverter(){

            @Override
            public Period redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getPeriod(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Duration.class, new ClassInstanceConverter(){

            @Override
            public Duration redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getDuration(byArray);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Clob.class, new ClassInstanceConverter(){

            @Override
            public Clob redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getClob(byArray, yasConnection.getSession());
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Blob.class, new ClassInstanceConverter(){

            @Override
            public Blob redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getBlob(byArray, yasConnection.getSession());
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(SQLXML.class, new ClassInstanceConverter(){

            @Override
            public SQLXML redirect(Accessor accessor, byte[] byArray, YasConnection yasConnection) throws SQLException {
                return accessor.getSQLXML(byArray);
            }
        });
    }
}

