/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.TransactionState;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.Packet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ExecuteResult {
    private int batchRows;
    private final short outParams;
    private final short marginColumns;
    private final long affectedRows;
    private final long xactStatus;
    private final boolean hasMoreRows;
    private boolean hasBatchRows;
    private final boolean hasBatchError;
    private int[] dmlRows;
    private boolean inBatchMode = false;
    private Map batchErrors;

    public ExecuteResult(Packet packet) throws SQLException {
        this(packet, false);
    }

    public ExecuteResult(Packet packet, boolean bl) throws SQLException {
        this.batchRows = packet.getInt();
        this.outParams = packet.getShort();
        this.marginColumns = packet.getShort();
        long l = packet.getLong();
        this.affectedRows = l & 0xFFFFFFFFFFL;
        this.xactStatus = (l & 0x30000000000L) >>> 40;
        this.hasMoreRows = (l & 0x100000000000L) == 0x100000000000L;
        this.hasBatchRows = (l & 0x200000000000L) == 0x200000000000L;
        this.hasBatchError = (l & 0x400000000000L) == 0x400000000000L;
        this.inBatchMode = bl;
    }

    public void getDMLError(Packet packet) throws SQLException {
        if (this.hasBatchRows) {
            this.dmlRows = this.a(packet);
            if (this.hasBatchError) {
                this.batchErrors = this.a(packet, this.dmlRows);
            }
        }
        if (this.inBatchMode && this.dmlRows == null) {
            this.hasBatchRows = true;
            this.batchRows = 1;
            this.dmlRows = new int[1];
            this.dmlRows[0] = (int)this.affectedRows;
        }
    }

    public boolean hasMoreRows() {
        return this.hasMoreRows;
    }

    public int getBatchRows() {
        return this.batchRows;
    }

    public short getOutParams() {
        return this.outParams;
    }

    public short getMarginColumns() {
        return this.marginColumns;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public TransactionState getXactStatus() {
        return TransactionState.values()[(int)this.xactStatus];
    }

    private int[] a(Packet packet) {
        int n = packet.getInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = packet.getInt();
            nArray[i] = nArray[i] == -1 ? -3 : nArray[i];
        }
        return nArray;
    }

    private Map a(Packet packet, int[] nArray) throws SQLException {
        HashMap<Integer, BatchError> hashMap = new HashMap<Integer, BatchError>();
        int n = packet.getInt();
        for (int i = 0; i < n; ++i) {
            int n2 = packet.getInt();
            if (n2 < 0 || nArray == null || n2 > nArray.length) {
                throw SQLError.createSQLException("BatchError protocol wrong.", YasState.UNKNOWN_STATE);
            }
            int n3 = packet.getInt();
            int n4 = packet.getInt();
            String string = packet.getString(n4);
            hashMap.put(n2, new BatchError(n3, string));
        }
        return hashMap;
    }

    public int[] getDmlRows() {
        return this.dmlRows;
    }

    public Map getBatchErrors() {
        return this.batchErrors;
    }

    public boolean isHasBatchRows() {
        return this.hasBatchRows;
    }

    public boolean isHasBatchError() {
        return this.hasBatchError;
    }
}

