/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;

public class InternalTimeStamp {
    private int year;
    private int month;
    private int date;
    private int hour;
    private int minute;
    private int second;
    private int fraction;

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        this.month = n;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int n) {
        this.date = n;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int n) {
        this.hour = n;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int n) {
        this.minute = n;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int n) {
        this.second = n;
    }

    public int getFraction() {
        return this.fraction;
    }

    public void setFraction(int n) {
        this.fraction = n;
    }

    public void setDateAndTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.date = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.fraction = calendar.get(14) * 1000;
    }

    public void setTime(long l) {
        this.setDateAndTime(l);
    }

    public void setValueForCalendar(Calendar calendar) {
        calendar.set(this.year, this.month - 1, this.date, this.hour, this.minute, this.second);
        calendar.set(14, this.fraction / 1000);
    }

    public LocalTime getLocalTime() {
        return LocalTime.of(this.hour, this.minute, this.second, this.fraction * 1000);
    }

    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.of(this.year, this.month, this.date, this.hour, this.minute, this.second, this.fraction * 1000);
    }

    public LocalDate getLocalDate() {
        return LocalDate.of(this.year, this.month, this.date);
    }

    public static InternalTimeStamp transValueToTimeStamp(long l) {
        int n;
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        long l2 = l + 210866803200000000L;
        int n2 = (int)(l2 / 86400000000L);
        int n3 = (n2 += 32044) / 146097;
        int n4 = (n2 - n3 * 146097) * 4 + 3;
        n2 += 60 + n3 * 3 + n4 / 146097;
        n2 = ((n = (n2 -= (n3 = n2 / 1461) * 1461) * 4 / 1461) != 0 ? (n2 + 305) % 365 : (n2 + 306) % 366) + 123;
        internalTimeStamp.setYear((n += n3 * 4) - 4800);
        n3 = n2 * 2141 / 65536;
        internalTimeStamp.setDate(n2 - 7834 * n3 / 256);
        internalTimeStamp.setMonth((n3 + 10) % 12 + 1);
        long l3 = l2 % 86400000000L;
        internalTimeStamp.setHour((int)(l3 / 3600000000L));
        internalTimeStamp.minute = (int)((l3 -= (long)internalTimeStamp.hour * 3600000000L) / 60000000L);
        internalTimeStamp.second = (int)((l3 -= (long)internalTimeStamp.minute * 60000000L) / 1000000L);
        internalTimeStamp.setFraction((int)(l3 % 1000000L));
        if (internalTimeStamp.getYear() == -1) {
            internalTimeStamp.setYear(0);
            internalTimeStamp.month -= 12;
            if (internalTimeStamp.getMonth() == -1) {
                internalTimeStamp.setMonth(0);
                internalTimeStamp.setDate(0);
            }
        }
        if (internalTimeStamp.getYear() == 1582 && internalTimeStamp.getMonth() == 10 && internalTimeStamp.getDate() > 4 && internalTimeStamp.getDate() < 15) {
            internalTimeStamp.date += 10;
        }
        return internalTimeStamp;
    }

    public static long transTimeStampToValue(InternalTimeStamp internalTimeStamp) {
        int n = internalTimeStamp.getYear();
        int n2 = internalTimeStamp.getMonth();
        if (n2 > 2) {
            ++n2;
            n += 4800;
        } else {
            n2 += 13;
            n += 4799;
        }
        int n3 = n / 100;
        int n4 = n * 365 - 32167;
        n4 += n / 4 - n3 + n3 / 4;
        long l = (long)(n4 += 7834 * n2 / 256 + internalTimeStamp.getDate()) * 86400000000L;
        l += (long)internalTimeStamp.hour * 3600000000L;
        l += (long)internalTimeStamp.minute * 60000000L;
        l += (long)(internalTimeStamp.second * 1000000);
        return (l += (long)internalTimeStamp.getFraction()) - 210866803200000000L;
    }

    public static InternalTimeStamp transValueToTime(long l) {
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        LocalDate localDate = LocalDate.now();
        internalTimeStamp.setDate(1);
        internalTimeStamp.setYear(localDate.getYear());
        internalTimeStamp.setMonth(localDate.getMonthValue());
        long l2 = l % 86400000000L;
        internalTimeStamp.setHour((int)(l2 / 3600000000L));
        internalTimeStamp.minute = (int)((l2 -= (long)internalTimeStamp.hour * 3600000000L) / 60000000L);
        internalTimeStamp.second = (int)((l2 -= (long)internalTimeStamp.minute * 60000000L) / 1000000L);
        internalTimeStamp.setFraction((int)(l2 % 1000000L));
        return internalTimeStamp;
    }

    public static long transTimeToValue(InternalTimeStamp internalTimeStamp) {
        long l = 0L;
        l += (long)internalTimeStamp.hour * 3600000000L;
        l += (long)internalTimeStamp.minute * 60000000L;
        l += (long)(internalTimeStamp.second * 1000000);
        return l += (long)internalTimeStamp.getFraction();
    }
}

