/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Period;

public class IntervalType {
    private static final String PRECISION_TOO_SMALL = "the leading precision is too small";
    private static final String INTERVAL_INVALID = "the interval is invalid";

    private IntervalType() {
    }

    private static int a(String string) {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        return n;
    }

    private static String b(String string) {
        char c = string.charAt(0);
        if (c == '-' || c == '+') {
            return string.substring(1);
        }
        return string;
    }

    private static String c(String string) throws SQLException {
        int n;
        IntervalType.e(string);
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n > 9) {
            throw SQLError.createSQLException(PRECISION_TOO_SMALL, YasState.DATA_ERROR);
        }
        return string.substring(0, n);
    }

    private static int d(String string) throws SQLException {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw SQLError.createSQLException(INTERVAL_INVALID, YasState.DATA_ERROR);
        }
        if (l > 0xFFFFFFFFL) {
            throw SQLError.createSQLException(PRECISION_TOO_SMALL, YasState.DATA_ERROR);
        }
        return (int)l;
    }

    private static String a(String string, char c) throws SQLException {
        IntervalType.e(string);
        if (string.charAt(0) != c) {
            throw SQLError.createSQLException(INTERVAL_INVALID, YasState.DATA_ERROR);
        }
        return string.substring(1);
    }

    private static void e(String string) throws SQLException {
        if (string.isEmpty()) {
            throw SQLError.createSQLException(INTERVAL_INVALID, YasState.DATA_ERROR);
        }
    }

    private static int f(String string) throws SQLException {
        int n = IntervalType.d(string);
        if (n > 178000000) {
            throw SQLError.createSQLException("the year is out of range", YasState.DATA_ERROR);
        }
        return n;
    }

    private static int g(String string) throws SQLException {
        int n = IntervalType.d(string);
        if (n >= 12) {
            throw SQLError.createSQLException("not a valid month", YasState.DATA_ERROR);
        }
        return n;
    }

    private static int h(String string) throws SQLException {
        int n = IntervalType.d(string);
        if (n > 100000000) {
            throw SQLError.createSQLException("the day is out of range", YasState.DATA_ERROR);
        }
        return n;
    }

    private static int i(String string) throws SQLException {
        int n = IntervalType.d(string);
        if (n >= 24) {
            throw SQLError.createSQLException("not a valid hour", YasState.DATA_ERROR);
        }
        return n;
    }

    private static int j(String string) throws SQLException {
        int n = IntervalType.d(string);
        if (n >= 60) {
            throw SQLError.createSQLException("not a valid minute", YasState.DATA_ERROR);
        }
        return n;
    }

    private static int k(String string) throws SQLException {
        int n = IntervalType.d(string);
        if (n >= 60) {
            throw SQLError.createSQLException("not a valid second", YasState.DATA_ERROR);
        }
        return n;
    }

    private static int l(String string) throws SQLException {
        IntervalType.e(string);
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i))) {
                throw SQLError.createSQLException("not a valid fraction", YasState.DATA_ERROR);
            }
            n *= 10;
            n += string.charAt(i) - 48;
        }
        if (string.length() > 9) {
            throw SQLError.createSQLException(PRECISION_TOO_SMALL, YasState.DATA_ERROR);
        }
        if (string.length() > 6) {
            double d = (double)n / (double)YasConstants.getPrecisionLimit(string.length() - 6);
            n = (int)Math.round(d);
        }
        if (string.length() < 6) {
            n *= YasConstants.getPrecisionLimit(6 - string.length());
        }
        return n;
    }

    public static long convertStringToDsInterval(String string) throws SQLException {
        string = string.trim();
        long l = 0L;
        IntervalType.e(string);
        int n = IntervalType.a(string);
        string = IntervalType.b(string).trim();
        String string2 = IntervalType.c(string);
        int n2 = IntervalType.h(string2);
        l += (long)n2 * 86400000000L;
        string = string.substring(string2.length());
        string = IntervalType.a(string, ' ').trim();
        string2 = IntervalType.c(string);
        int n3 = IntervalType.i(string2);
        l += (long)n3 * 3600000000L;
        string = string.substring(string2.length()).trim();
        string = IntervalType.a(string, ':').trim();
        string2 = IntervalType.c(string);
        int n4 = IntervalType.j(string2);
        l += (long)n4 * 60000000L;
        string = string.substring(string2.length()).trim();
        string = IntervalType.a(string, ':').trim();
        string2 = IntervalType.c(string);
        int n5 = IntervalType.k(string2);
        l += (long)n5 * 1000000L;
        string = string.substring(string2.length());
        if (string.length() > 0) {
            string = string.trim();
            string = IntervalType.a(string, '.').trim();
            int n6 = IntervalType.l(string);
            l += (long)n6;
        }
        if (l > 8640000000000000000L) {
            throw SQLError.createSQLException("the interval is out of range", YasState.UNKNOWN_STATE);
        }
        if (n > 0) {
            l = -l;
        }
        return l;
    }

    public static String convertDsIntervalToString(long l) {
        String string = "";
        String string2 = "+";
        if (l < 0L) {
            string2 = "-";
            l = -l;
        }
        string = string + string2;
        int n = (int)(l / 86400000000L);
        string = string + String.format("%02d", n);
        string = string + ' ';
        int n2 = (int)(l / 3600000000L % 24L);
        string = string + String.format("%02d", n2);
        string = string + ':';
        int n3 = (int)(l / 60000000L % 60L);
        string = string + String.format("%02d", n3);
        string = string + ':';
        int n4 = (int)(l / 1000000L % 60L);
        string = string + String.format("%02d", n4);
        string = string + '.';
        int n5 = (int)(l % 1000000L);
        string = string + String.format("%06d", n5);
        return string;
    }

    public static Duration convertDsIntervalToDuration(long l) {
        int n = (int)(l / 86400000000L);
        Duration duration = Duration.ofDays(n);
        int n2 = (int)(l / 3600000000L % 24L);
        duration = duration.plusHours(n2);
        int n3 = (int)(l / 60000000L % 60L);
        duration = duration.plusMinutes(n3);
        int n4 = (int)(l / 1000000L % 60L);
        duration = duration.plusSeconds(n4);
        int n5 = (int)(l % 1000000L);
        duration = duration.plusNanos((long)n5 * 1000L);
        return duration;
    }

    public static int convertStringToYmInterval(String string) throws SQLException {
        string = string.trim();
        int n = 0;
        IntervalType.e(string);
        int n2 = IntervalType.a(string);
        string = IntervalType.b(string).trim();
        String string2 = IntervalType.c(string);
        int n3 = IntervalType.f(string2);
        n += n3 * 12;
        string = string.substring(string2.length());
        string = IntervalType.a(string, '-').trim();
        string2 = IntervalType.c(string);
        int n4 = IntervalType.g(string2);
        n += n4;
        string = string.substring(string2.length());
        if (string.length() != 0) {
            throw SQLError.createSQLException(INTERVAL_INVALID, YasState.DATA_ERROR);
        }
        if (n > 2136000000) {
            throw SQLError.createSQLException("the interval is out of range", YasState.DATA_ERROR);
        }
        if (n2 > 0) {
            n = -n;
        }
        return n;
    }

    public static String convertYmIntervalToString(int n) {
        String string = "";
        String string2 = "+";
        if (n < 0) {
            string2 = "-";
            n = -n;
        }
        string = string + string2;
        int n2 = n / 12;
        string = string + String.format("%02d", n2);
        string = string + '-';
        int n3 = n % 12;
        string = string + String.format("%02d", n3);
        return string;
    }

    public static Period convertYmIntervalToPeriod(int n) {
        int n2 = n / 12;
        int n3 = n % 12;
        return Period.of(n2, n3, 0);
    }
}

