/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.Session;
import com.yashandb.YasConstants;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasRuntimeException;
import com.yashandb.exception.YasState;
import com.yashandb.exception.YasWarning;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.ServerErrorMessage;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.AckConnBuffer;
import com.yashandb.protocol.Buffer;
import com.yashandb.protocol.ConnectionServerMode;
import com.yashandb.protocol.ErrorBuffer;
import com.yashandb.protocol.MsgType;
import com.yashandb.protocol.Packet;
import com.yashandb.protocol.Protocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.protocol.jni.GmsslDll;
import com.yashandb.protocol.jni.UKeyInfo;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import com.yashandb.util.YasEncrypt;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeProtocol
implements Protocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeProtocol.class.getName());
    protected final YasSocketConnection yasSocketConnection;
    protected final Session session;
    private int packetSize = 0;
    private short charset;
    private Packet send;
    private Packet receive;
    private byte conServerMode = 0;
    private boolean isHeartbeatConn = false;
    private boolean isTlcp = false;
    private long gmsslConn;
    private int fd;
    private static final int LOGIN_FLAG_IS_HB_CONN = 1;
    private static final String SERVER_ID = "YASDB";
    private static final String UKEY_SID = "10979831112SM2";
    private static final String LOGIN_FAIL = "login fail: ";

    public NativeProtocol(Session session, YasSocketConnection yasSocketConnection) {
        this.yasSocketConnection = yasSocketConnection;
        this.session = session;
        this.send = null;
        this.receive = null;
    }

    @Override
    public void connect(String string, String string2, Properties properties) throws SQLException {
        try {
            String string3;
            int n = this.yasSocketConnection.getNetworkTimeout();
            int n2 = Utils.toMillisecond(YasProperty.LOGIN_TIMEOUT.getInt(properties));
            if (n2 > 0) {
                this.yasSocketConnection.setNetworkTimeout(n2);
            }
            if ((string3 = YasProperty.SSL_ROOT_CER.get(properties)) != null && !string3.trim().equals("")) {
                this.yasSocketConnection.setSslRootCer(string3);
            }
            this.a(properties);
            this.a(string, string2, properties);
            this.a();
            this.yasSocketConnection.setNetworkTimeout(n);
        }
        catch (IOException iOException) {
            LOGGER.error(LOGIN_FAIL + iOException.getMessage());
            throw SQLError.createSQLException(LOGIN_FAIL + iOException.getMessage(), YasState.IO_ERROR, (Throwable)iOException);
        }
    }

    public void cancel(Properties properties, int n) throws SQLException {
        this.a(properties);
        try {
            this.yasSocketConnection.setNetworkTimeout(n);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(LOGIN_FAIL + iOException.getMessage(), YasState.IO_ERROR, (Throwable)iOException);
        }
        Packet packet = this.getSendPacket();
        packet.writeShort(this.session.getSID());
        packet.skip(2);
        packet.writeInt(this.session.getSessionKey());
        this.sendCommand(packet, MsgType.CMD_CANCEL_CURR, 0);
    }

    @Override
    public void sendBuffer(Buffer buffer) throws SQLException {
        try {
            this.yasSocketConnection.send(buffer);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException("io fail:" + iOException.getMessage(), YasState.IO_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public void sendPacket(Packet packet) throws SQLException {
        packet.encode(this.session.getConnectVersion());
        if (this.isTlcp) {
            int n = packet.getPostion();
            int n2 = 0;
            int n3 = GmsslDll.tlcpSend(this.gmsslConn, Arrays.copyOfRange(packet.getBuffer(), n2, n + n2), n, this.fd);
            if (n3 < n) {
                throw SQLError.createSQLException(Messages.get("protocol error", new Object[0]), YasState.IO_ERROR);
            }
            return;
        }
        this.sendBuffer(packet);
        try {
            this.yasSocketConnection.flush();
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("protocol error", new Object[0]), YasState.IO_ERROR);
        }
    }

    @Override
    public YasSocketConnection getSocketConnection() {
        return this.yasSocketConnection;
    }

    @Override
    public Packet receivePacket() throws SQLException {
        if (this.receive == null) {
            this.receive = new Packet(this.packetSize, CharacterSet.getCharSet(this.charset));
        }
        this.receive.clean();
        try {
            if (this.isTlcp) {
                this.a(this.receive, 0, 8);
                this.a(this.receive, 8, this.receive.getMessageSize());
            } else {
                this.yasSocketConnection.receive(this.receive, 0, 8);
                this.yasSocketConnection.receive(this.receive, 8, this.receive.getMessageSize());
            }
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException("io fail:" + iOException.getMessage(), YasState.IO_ERROR, (Throwable)iOException);
        }
        this.a(this.receive);
        this.checkServerError(this.receive);
        return this.receive;
    }

    private void a(Buffer buffer, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        byte[] byArray = new byte[n2];
        int n3 = GmsslDll.tlcpRecv(this.gmsslConn, byArray, n2, this.fd);
        if (n3 < n2) {
            throw new IOException("receive error");
        }
        System.arraycopy(byArray, 0, buffer.getBuffer(), n, n2);
    }

    @Override
    public Packet sendCommand(Packet packet, MsgType msgType, int n) throws SQLException {
        packet.setCmd(msgType);
        this.sendPacket(packet);
        return this.receivePacket();
    }

    public void sendCommandOnly(Packet packet, MsgType msgType) throws SQLException {
        packet.setCmd(msgType);
        this.sendPacket(packet);
    }

    @Override
    public Packet getSendPacket() {
        if (this.send == null) {
            this.send = new Packet(this.packetSize, CharacterSet.getCharSet(this.charset));
        }
        this.send.clean();
        return this.send;
    }

    @Override
    public void setServerMode(ConnectionServerMode connectionServerMode) {
        this.conServerMode = (byte)connectionServerMode.getValue();
    }

    private void a(Properties properties) throws SQLException {
        AckConnBuffer ackConnBuffer = new AckConnBuffer();
        try {
            this.yasSocketConnection.receive(ackConnBuffer, 0, 16);
            ackConnBuffer.skip(1);
            this.packetSize = ackConnBuffer.b();
            ackConnBuffer.setPostion(1);
            byte by = ackConnBuffer.getByte();
            if (by == 2) {
                this.yasSocketConnection.changeSocketToSsl();
            } else if (by == 3) {
                this.c(properties);
            }
            this.charset = ackConnBuffer.getShort();
            ackConnBuffer.setPostion(8);
            if (!Arrays.equals(ackConnBuffer.getBytes(8), YasConstants.getYasNumber())) {
                throw new YasRuntimeException("Incorrect protocol implementation");
            }
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException("The connection attempt failed.", YasState.IO_ERROR, (Throwable)iOException);
        }
    }

    private void a() throws SQLException {
        Packet packet = this.getSendPacket();
        Packet packet2 = this.sendCommand(packet, MsgType.CMD_SESSION_PARAM, 0);
        int n = packet2.getShort();
        for (int i = 0; i < n; ++i) {
            byte[] byArray;
            byte by = packet2.getByte();
            String string = new String(packet2.getBytes(by, byArray = new byte[by]));
            if (string.equals("NCHARSET")) {
                packet2.skip(1);
                this.session.setNCharset(packet2.getShort());
                continue;
            }
            if (string.equals("YASDB_OFFICIAL_VERSION")) {
                this.session.setYasdbVersion(packet2.getString(packet2.getByte()));
                continue;
            }
            if (string.equals("PACKET_SEND_TIMEOUT")) {
                packet2.skip(1);
                this.session.setServerSendTimeout(packet2.getInt());
                continue;
            }
            byte by2 = packet2.getByte();
            byArray = new byte[by2];
            packet2.getBytes(by2, byArray);
        }
    }

    private void a(String string, String string2, Properties properties) throws SQLException {
        this.b(string, string2, properties);
        this.session.setSID(this.receive.getShort());
        this.receive.skip(2);
        this.session.setCharset(this.charset);
        int n = this.receive.getInt();
        if (ConnectVersion.valueOf(n) == ConnectVersion.UNINITIALIZED) {
            n = ConnectVersion.VER1.getValue();
        }
        this.session.setConnectVersion(ConnectVersion.valueOf(n));
        this.session.setSessionKey(this.receive.getInt());
    }

    private void b(String string, String string2, Properties properties) throws SQLException {
        this.doSecretLogin(string, string2, properties);
    }

    private String b() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = string.contains("windows") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        if (string2 != null) {
            return string2;
        }
        return this.yasSocketConnection.getSocket().getLocalAddress().getCanonicalHostName();
    }

    private String a(String string) {
        if (this.session.isUserCaseSensitive()) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private byte c() {
        byte by = 0;
        if (this.isHeartbeatConn) {
            by = (byte)(by | 1);
        }
        return by;
    }

    public void doSecretLogin(String string, String string2, Properties properties) throws SQLException {
        String string3 = System.getProperty("user.name");
        String string4 = this.b();
        if (string4 == null) {
            string4 = "";
        }
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            throw SQLError.createSQLException("null user/password given; login denied", YasState.CONNECTION_UNABLE_TO_CONNECT);
        }
        String string5 = YasProperty.PROGRAM_NAME.get(properties);
        Packet packet = this.getSendPacket();
        packet.writeInt(this.session.getConnectVersion().getValue());
        packet.writeByte((byte)1);
        packet.writeByte((byte)0);
        packet.writeByte(this.conServerMode);
        packet.writeByte(this.c());
        string = this.a(string);
        packet.writeStringWithByteLength(string);
        packet.writeStringWithByteLength(string3);
        packet.writeStringWithByteLength(string4);
        packet.writeStringWithByteLength(string5);
        Packet packet2 = this.sendCommand(packet, MsgType.CMD_LOGIN, 0);
        int n = packet2.getInt();
        int n2 = packet2.getInt();
        int n3 = n2 & 0xFF;
        boolean bl = (n2 & 0x100) != 0;
        short s = packet2.getShort();
        String string6 = packet2.getString(s);
        short s2 = packet2.getShort();
        byte[] byArray = packet2.getBytes(s2);
        String string7 = YasEncrypt.encryptSHA(string2, string6, n);
        if (string7 == null) {
            throw SQLError.createSQLException("Encrypt SHA password fail", YasState.UNKNOWN_STATE);
        }
        Packet packet3 = this.getSendPacket();
        if (n3 != 3) {
            byte[] byArray2 = YasEncrypt.decrypt(string7.getBytes(), byArray, n3);
            if (byArray2 == null) {
                throw SQLError.createSQLException("decryptDes plainKey fail", YasState.UNKNOWN_STATE);
            }
            byte[] byArray3 = YasEncrypt.encrypt(byArray2, string2.getBytes(), n3);
            if (byArray3 == null) {
                throw SQLError.createSQLException("encryptDes secretPassword fail", YasState.UNKNOWN_STATE);
            }
            packet3.writeShort((short)byArray3.length);
            packet3.writeBytes(byArray3);
        } else {
            byte[] byArray4 = YasEncrypt.encryptSM4(string7.getBytes(), byArray);
            packet3.writeShort((short)byArray4.length);
            packet3.writeBytes(byArray4);
        }
        this.sendCommand(packet3, MsgType.CMD_DIGEST, 0);
        if (bl) {
            this.b(properties);
        }
    }

    private void b(Properties properties) throws SQLException {
        short s = this.receive.getShort();
        byte[] byArray = this.receive.getBytes(s);
        byte[] byArray2 = Utils.getRandomString(32).getBytes();
        String string = YasProperty.UKEY_NAME.checkExistAndGet(properties);
        String string2 = YasProperty.UKEY_PIN.checkExistAndGet(properties);
        byte[] byArray3 = new byte[128];
        System.arraycopy(UKEY_SID.getBytes(), 0, byArray3, 0, UKEY_SID.length());
        System.arraycopy(byArray2, 0, byArray3, 32, 32);
        System.arraycopy(byArray, 0, byArray3, 64, 32);
        System.arraycopy(SERVER_ID.getBytes(), 0, byArray3, 96, SERVER_ID.length());
        UKeyInfo uKeyInfo = new UKeyInfo(string, string2);
        byte[] byArray4 = uKeyInfo.sign(byArray3);
        uKeyInfo.close();
        Packet packet = this.getSendPacket();
        packet.writeShort((short)byArray2.length);
        packet.writeBytes(byArray2);
        packet.writeShort((short)byArray4.length);
        packet.writeBytes(byArray4);
        this.sendCommand(packet, MsgType.CMD_SIGN, 0);
    }

    private void a(Packet packet) throws SQLException {
        MsgType msgType = packet.getCmd();
        if (packet.getCmdVersion() != msgType.getVersion(this.session.getConnectVersion())) {
            throw SQLError.createSQLException("protocol error, command version is not compatible", YasState.PROTOCOL_VIOLATION);
        }
    }

    public void checkServerError(Packet packet) throws SQLException {
        if (packet.isError()) {
            ErrorBuffer errorBuffer = new ErrorBuffer(packet, CharacterSet.getCharSet(this.charset));
            ServerErrorMessage serverErrorMessage = new ServerErrorMessage(errorBuffer.getErrorCode(), errorBuffer.getLine(), errorBuffer.getColumn(), errorBuffer.getErrorMsg());
            LOGGER.error(serverErrorMessage.toString());
            throw SQLError.createSQLException(serverErrorMessage, true);
        }
        if (packet.hasInfo()) {
            ErrorBuffer errorBuffer = new ErrorBuffer(packet, CharacterSet.getCharSet(this.charset));
            ServerErrorMessage serverErrorMessage = new ServerErrorMessage(errorBuffer.getErrorCode(), errorBuffer.getLine(), errorBuffer.getColumn(), errorBuffer.getErrorMsg());
            YasWarning yasWarning = new YasWarning(serverErrorMessage);
            this.session.addWarning(yasWarning);
            LOGGER.warn(serverErrorMessage.toString());
        }
    }

    private void c(Properties properties) throws SQLException {
        String string = YasProperty.TLCP_CACERT_FILE.checkExistAndGet(properties);
        String string2 = YasProperty.TLCP_CERT_FILE.checkExistAndGet(properties);
        String string3 = YasProperty.TLCP_CLIENT_KEY_FILE.checkExistAndGet(properties);
        String string4 = YasProperty.TLCP_CLIENT_KEY_PASS.checkExistAndGet(properties);
        if (!Utils.checkFileExists(string)) {
            throw SQLError.createSQLException("cacert does not exist:" + string, YasState.UNKNOWN_STATE);
        }
        if (!Utils.checkFileExists(string2)) {
            throw SQLError.createSQLException("certFile does not exist:" + string2, YasState.UNKNOWN_STATE);
        }
        if (!Utils.checkFileExists(string3)) {
            throw SQLError.createSQLException("clientKeyFile does not exist:" + string3, YasState.UNKNOWN_STATE);
        }
        this.fd = this.yasSocketConnection.getSocketFd();
        long l = GmsslDll.initTlcpCtx();
        this.d();
        if (GmsslDll.setCaCertFile(l, string) != 0) {
            throw SQLError.createSQLException("Please check if the tlcp cacert file is correct:" + string3, YasState.UNKNOWN_STATE);
        }
        if (GmsslDll.setCerAndKey(l, string2, string3, string4) != 0) {
            throw SQLError.createSQLException("Please check if the tlcp certFile/clientKeyFile/clientKeyPassword is correct:" + string3, YasState.UNKNOWN_STATE);
        }
        long l2 = GmsslDll.tlcpInit(l);
        if (GmsslDll.tlcpSetSocket(l2, this.fd) != 0L) {
            GmsslDll.shutdown(l2);
            throw SQLError.createSQLException("tlcpSetSocket error.", YasState.UNKNOWN_STATE);
        }
        if (GmsslDll.tlcpHandShake(l2, this.fd) != 0L) {
            GmsslDll.shutdown(l2);
            throw SQLError.createSQLException("tlcpHandShake error.", YasState.UNKNOWN_STATE);
        }
        this.isTlcp = true;
        this.gmsslConn = l2;
        this.yasSocketConnection.setGmsslConn(l2);
    }

    public void setHeartbeatLink() {
        this.isHeartbeatConn = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        if (GmsslDll.hasAddHook.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = GmsslDll.hasAddHook;
        synchronized (atomicBoolean) {
            if (GmsslDll.hasAddHook.get()) {
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GmsslDll.releaseEnv();
                }
            });
            GmsslDll.hasAddHook.set(true);
        }
    }
}

