/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.ParameterList;
import com.yashandb.SessionImpl;
import com.yashandb.YasResultSet;
import com.yashandb.core.DataType;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.DebugFrameImpl;
import com.yashandb.jdbc.DebugVarImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetFactory;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataFactory;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.YasDebugCallableStatement;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasBatchUpdateException;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.LobOperation;
import com.yashandb.protocol.MsgType;
import com.yashandb.protocol.Packet;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.protocol.debug.DebugFrameInfo;
import com.yashandb.protocol.debug.DebugOperation;
import com.yashandb.protocol.debug.DebugVarInfo;
import com.yashandb.protocol.debug.DebugVariantInfo;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.CharacterSet;
import com.yashandb.xa.YasXAConnection;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class PacketProcessor {
    private static final int PREPARE_MASK_LEN = -2;
    private static final int SQL_LEN_MORE_FLAG = 1;
    private static final int PREPARE_ACK_NULLABLE_FLAG = 1;
    private static final int EXECUTE_FLAG_AUTO_COMMIT = 1;
    private static final int EXECUTE_FLAG_DML_ROW = 4;
    private static final int EXECUTE_FLAG_BATCH_ERROR = 8;
    private static final int EXECUTE_FLAG_DEBUG = 128;
    private static final int LOB_FLAG_DATA_IS_LOB = 1;
    private static final int LOB_FLAG_IS_STREAM = 2;
    private static final int LOB_FLAG_IS_CHAR_REQ = 4;
    private static final int ACK_FETCH_FLAG_OFFSET = 16;
    private static final long ACK_FETCH_HAS_MORE_ROWS_MASK = 0x100000000000L;

    private PacketProcessor() {
    }

    public static void writeReqSql(Packet packet, byte[] byArray, int n, int n2, boolean bl) {
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        int n4 = n2 << 1;
        n3 |= (n4 &= 0xFFFFFFFE);
        if (bl) {
            n3 |= 1;
        }
        packet.writeInt(n3);
        packet.writeBytes(byArray, n, n2);
    }

    public static void writeReqPrepare(StatementImpl statementImpl, Packet packet) {
        packet.writeShort(statementImpl.getID());
        packet.skip(2);
    }

    private static byte a(boolean bl) {
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        return by;
    }

    private static byte a(boolean bl, boolean bl2) {
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        if (bl2) {
            by = (byte)(by | 0x80);
        }
        return by;
    }

    private static byte a(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        if (bl2) {
            by = (byte)(by | 4);
        }
        if (bl3) {
            by = (byte)(by | 8);
        }
        if (bl4) {
            by = (byte)(by | 0x80);
        }
        return by;
    }

    public static byte getReqLobFlag(boolean bl, boolean bl2, boolean bl3) {
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        if (bl2) {
            by = (byte)(by | 2);
        }
        if (bl3) {
            by = (byte)(by | 4);
        }
        return by;
    }

    public static void writeReqLob(Packet packet, LobOperation lobOperation, YasLobProcessor yasLobProcessor, int n, long l, byte by) {
        byte[] byArray = yasLobProcessor.getLobLocator();
        int n2 = yasLobProcessor.getLobType();
        packet.writeByte((byte)lobOperation.getValue());
        packet.writeByte(by);
        packet.writeByte((byte)n2);
        if (byArray == null) {
            packet.writeByte((byte)yasLobProcessor.getCsLobLocatorSize());
        } else {
            packet.writeByte((byte)byArray.length);
        }
        packet.writeInt(n);
        packet.writeLong(l);
        if (byArray == null) {
            packet.skip(80);
        } else {
            packet.writeBytes(byArray);
        }
    }

    private static int a(YasStatement yasStatement) {
        try {
            int n = yasStatement.getFetchSize();
            if (n == Integer.MIN_VALUE && !yasStatement.streamResultSetEnabled()) {
                n = 0;
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void writeReqExecute(YasStatement yasStatement, Packet packet, boolean bl) {
        packet.writeShort(yasStatement.getID());
        packet.writeByte(PacketProcessor.a(bl));
        packet.writeByte((byte)0);
        packet.writeShort(0);
        packet.writeShort(1);
        packet.writeInt(PacketProcessor.a(yasStatement));
    }

    public static void writeReqExecute(YasStatement yasStatement, Packet packet, boolean bl, boolean bl2) {
        packet.writeShort(yasStatement.getID());
        packet.writeByte(PacketProcessor.a(bl, bl2));
        packet.writeByte((byte)0);
        packet.writeShort(0);
        packet.writeShort(1);
        packet.writeInt(PacketProcessor.a(yasStatement));
    }

    public static void writeFetchCursor(short s, Packet packet, int n) {
        packet.writeShort(s);
        packet.writeByte(PacketProcessor.a(false));
        packet.writeByte((byte)0);
        packet.writeShort(0);
        packet.writeShort(1);
        packet.writeInt(n);
    }

    public static void writeReqFetch(YasStatement yasStatement, Packet packet) {
        packet.writeShort(yasStatement.getID());
        packet.writeShort(0);
    }

    public static void writeReqExecute(StatementImpl statementImpl, Packet packet, ParameterList[] parameterListArray, boolean bl, boolean bl2) throws SQLException {
        packet.writeShort(statementImpl.getID());
        if (parameterListArray.length > 1) {
            boolean bl3 = true;
            packet.writeByte(PacketProcessor.a(bl, bl3, statementImpl.getIsBatchError(), bl2));
        } else {
            packet.writeByte(PacketProcessor.a(bl, bl2));
        }
        packet.writeByte((byte)0);
        if (parameterListArray.length > 0) {
            packet.writeShort(parameterListArray[0].getParameterCount());
        } else {
            packet.writeShort(0);
        }
        packet.writeShort((short)parameterListArray.length);
        packet.writeInt(PacketProcessor.a(statementImpl));
        PacketProcessor.a(parameterListArray[0], packet);
    }

    public static void writeReqDirectExecute(StatementImpl statementImpl, Packet packet, ParameterList[] parameterListArray, boolean bl, boolean bl2) throws SQLException {
        packet.writeShort(statementImpl.getID());
        if (parameterListArray.length > 1) {
            boolean bl3 = true;
            packet.writeByte(PacketProcessor.a(bl, bl3, statementImpl.getIsBatchError(), bl2));
        } else {
            packet.writeByte(PacketProcessor.a(bl, bl2));
        }
        packet.skip(1);
        if (parameterListArray.length > 0) {
            packet.writeShort(parameterListArray[0].getParameterCount());
        } else {
            packet.writeShort(0);
        }
        packet.writeShort((short)parameterListArray.length);
        packet.writeInt(PacketProcessor.a(statementImpl));
    }

    public static void writeReqExecuteParamType(Packet packet, ParameterList[] parameterListArray) throws SQLException {
        PacketProcessor.a(parameterListArray[0], packet);
    }

    private static void a(ParameterList parameterList, Packet packet) throws YasException {
        if (parameterList != null) {
            for (int i = 0; i < parameterList.getParameterCount(); ++i) {
                YasParameter yasParameter = parameterList.getParameters()[i];
                if (yasParameter == null) {
                    throw SQLError.createSQLException("Parameter is missing,index:" + (i + 1), YasState.UNKNOWN_STATE);
                }
                yasParameter.writeInfo(packet);
            }
        }
    }

    public static long processLobMetaDataAck(YasLobProcessor yasLobProcessor, Packet packet, LobOperation lobOperation) throws SQLException {
        byte[] byArray = yasLobProcessor.getLobLocator();
        int n = packet.getByte();
        packet.skip(1);
        packet.skip(2);
        packet.skip(4);
        long l = packet.getLong();
        byte[] byArray2 = packet.getBytes(n);
        if (lobOperation == LobOperation.LOB_WRITE || lobOperation == LobOperation.LOB_TRIM) {
            yasLobProcessor.setLobLocator(byArray2);
        } else {
            for (int i = 0; i < n; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                throw new YasException("ack lob locator verify fail", YasState.DATA_ERROR);
            }
        }
        return l;
    }

    public static byte[] processLobCreateAck(Packet packet) throws SQLException {
        byte by = packet.getByte();
        packet.skip(1);
        packet.skip(2);
        packet.skip(4);
        packet.skip(8);
        return packet.getBytes(by);
    }

    public static int processLobDataAck(byte[] byArray, Packet packet, byte[] byArray2) throws SQLException {
        int n = packet.getByte();
        byte by = packet.getByte();
        boolean bl = (by & 1) != 0;
        packet.skip(2);
        int n2 = packet.getInt();
        packet.skip(8);
        byte[] byArray3 = packet.getBytes(n);
        for (int i = 0; i < n; ++i) {
            if (byArray3[i] == byArray[i]) continue;
            throw new YasException("ack lob locator verify fail", YasState.DATA_ERROR);
        }
        if (bl) {
            if (n2 < 0) {
                throw new YasException("lob data length wrong: " + n2, YasState.DATA_ERROR);
            }
            if (byArray2.length < n2) {
                throw new YasException("lob cache buffer size: " + byArray2.length + " is small than ack data length: " + n2, YasState.OUT_OF_MEMORY);
            }
            packet.getBytes(n2, byArray2);
            return n2;
        }
        return 0;
    }

    public static Packet processInteractPacket(StatementImpl statementImpl, Packet packet, SessionImpl sessionImpl) throws SQLException {
        while (packet.getCmd() == MsgType.CMD_RETURN_RESULT) {
            short s = packet.getShort();
            YasResultSet yasResultSet = sessionImpl.fetchReturnResultSet(s);
            statementImpl.addImplicitResultSet(yasResultSet);
            packet = sessionImpl.continueExecute();
        }
        return packet;
    }

    public static YasResultSet processFetchImplicitResultAck(StatementImpl statementImpl, Packet packet, SessionImpl sessionImpl) throws SQLException {
        short s = packet.getShort();
        short s2 = packet.getShort();
        short s3 = packet.getShort();
        byte by = packet.getByte();
        packet.skip(1);
        ExecuteResult executeResult = new ExecuteResult(packet);
        executeResult.getDMLError(packet);
        statementImpl.setStmtID(s, by);
        if (s2 <= 0 || s3 > 0) {
            throw SQLError.createSQLException("invalid return result", YasState.DATA_ERROR);
        }
        Field[] fieldArray = PacketProcessor.b(packet, s2);
        statementImpl.setFields(fieldArray);
        return PacketProcessor.a(statementImpl, fieldArray, executeResult, packet, sessionImpl);
    }

    public static YasResultSet processDirectExecuteAck(StatementImpl statementImpl, Packet packet, SessionImpl sessionImpl) throws SQLException {
        Field[] fieldArray;
        short s = packet.getShort();
        short s2 = packet.getShort();
        short s3 = packet.getShort();
        byte by = packet.getByte();
        packet.skip(1);
        ExecuteResult executeResult = new ExecuteResult(packet);
        statementImpl.setStmtID(s, by);
        if (s2 > 0) {
            fieldArray = PacketProcessor.b(packet, s2);
            statementImpl.setFields(fieldArray);
        } else {
            statementImpl.setFields(null);
        }
        if (s3 > 0) {
            fieldArray = PacketProcessor.a(packet, s3);
            statementImpl.setParameters(fieldArray);
        }
        executeResult.getDMLError(packet);
        return PacketProcessor.a(statementImpl, executeResult, packet, sessionImpl);
    }

    public static YasResultSet processExecuteAck(StatementImpl statementImpl, Packet packet, SessionImpl sessionImpl) throws SQLException {
        ExecuteResult executeResult = new ExecuteResult(packet);
        executeResult.getDMLError(packet);
        return PacketProcessor.a(statementImpl, executeResult, packet, sessionImpl);
    }

    public static YasResultSet processExecuteAckInBatchMode(StatementImpl statementImpl, Packet packet, SessionImpl sessionImpl) throws SQLException {
        ExecuteResult executeResult = new ExecuteResult(packet, true);
        executeResult.getDMLError(packet);
        return PacketProcessor.a(statementImpl, executeResult, packet, sessionImpl);
    }

    public static void processPrepareAck(StatementImpl statementImpl, Packet packet) throws SQLException {
        Field[] fieldArray;
        short s = packet.getShort();
        short s2 = packet.getShort();
        short s3 = packet.getShort();
        byte by = packet.getByte();
        packet.skip(1);
        statementImpl.setStmtID(s, by);
        if (s2 > 0) {
            fieldArray = PacketProcessor.b(packet, s2);
            statementImpl.setFields(fieldArray);
        }
        if (s3 > 0) {
            fieldArray = PacketProcessor.a(packet, s3);
            statementImpl.setParameters(fieldArray);
        }
    }

    private static Field[] a(Packet packet, short s) {
        Field[] fieldArray = new Field[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            int n = packet.getRowSize();
            String string = packet.getString(n);
            fieldArray[s2] = new Field(s2, string, 0, -1, 0, 0, 0);
        }
        return fieldArray;
    }

    private static Field[] b(Packet packet, short s) throws SQLException {
        Field[] fieldArray = new Field[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            packet.getRowSize();
            short s3 = packet.getShort();
            short s4 = packet.getShort();
            byte by = packet.getByte();
            byte by2 = packet.getByte();
            byte by3 = packet.getByte();
            int n = packet.getByte() & 1;
            byte by4 = packet.getByte();
            String string = packet.getString(by4);
            fieldArray[s2] = new Field(s3, string, by, s4, n, by2, by3);
            if (!DataType.isUdtType(by)) continue;
            byte by5 = packet.getByte();
            String string2 = packet.getString(by5);
            byte by6 = packet.getByte();
            String string3 = packet.getString(by6);
            fieldArray[s2].setUdtTypeOwner(string2);
            fieldArray[s2].setUdtTypeName(string3);
        }
        return fieldArray;
    }

    private static YasResultSet a(StatementImpl statementImpl, Field[] fieldArray, ExecuteResult executeResult, Packet packet, SessionImpl sessionImpl) throws SQLException {
        sessionImpl.setTransactionState(executeResult.getXactStatus());
        RowData rowData = RowDataFactory.createRowDataImpl(sessionImpl, statementImpl, packet, executeResult);
        rowData.decodeRows(0);
        return ResultSetFactory.createCachedResultSet(statementImpl, fieldArray, rowData);
    }

    private static YasResultSet a(StatementImpl statementImpl, ExecuteResult executeResult, Packet packet, SessionImpl sessionImpl) throws SQLException {
        YasResultSet yasResultSet;
        packet = PacketProcessor.b(statementImpl, executeResult, packet, sessionImpl);
        sessionImpl.setTransactionState(executeResult.getXactStatus());
        if (statementImpl.getColumnCount() == 0) {
            if (executeResult.isHasBatchRows()) {
                if (executeResult.isHasBatchError() && !statementImpl.getIsBatchError()) {
                    int n = (Integer)executeResult.getBatchErrors().keySet().iterator().next();
                    BatchError batchError = (BatchError)executeResult.getBatchErrors().values().iterator().next();
                    throw new YasBatchUpdateException(n, batchError, executeResult.getDmlRows());
                }
                yasResultSet = new ResultSetImpl(executeResult.getAffectedRows(), sessionImpl.getConnection(), statementImpl, executeResult.getDmlRows(), executeResult.getBatchErrors());
            } else {
                yasResultSet = new ResultSetImpl(executeResult.getAffectedRows(), sessionImpl.getConnection(), statementImpl);
            }
        } else {
            RowData rowData = RowDataFactory.createRowDataImpl(sessionImpl, statementImpl, packet, executeResult);
            rowData.decodeRows(0);
            yasResultSet = statementImpl.createResultSet(rowData);
            if (statementImpl.streamResultSetEnabled()) {
                ((ResultSetImpl)yasResultSet).setStreamRs(true);
                if (executeResult.hasMoreRows()) {
                    sessionImpl.setFetchingStreamRs(true);
                    sessionImpl.setStreamRsStmtId(statementImpl.getID());
                }
            }
        }
        return yasResultSet;
    }

    private static Packet b(StatementImpl statementImpl, ExecuteResult executeResult, Packet packet, SessionImpl sessionImpl) throws SQLException {
        if (executeResult.getOutParams() > 0) {
            byte[][] byArrayArray = new byte[executeResult.getOutParams()][];
            for (int i = 0; i < executeResult.getOutParams(); ++i) {
                int n;
                if (packet.hasReadToEnd()) {
                    packet = sessionImpl.moreData();
                }
                byArrayArray[i] = (byte[])((n = packet.getRowSize()) == 0 ? null : packet.getBytes(n));
            }
            Row row = new Row(byArrayArray);
            statementImpl.createParameterResult(row);
        }
        return packet;
    }

    public static void writeReqDebug(YasStatement yasStatement, Packet packet, DebugOperation debugOperation, int n) {
        packet.writeShort(yasStatement.getID());
        packet.writeByte((byte)debugOperation.getValue());
        packet.writeByte((byte)0);
        packet.writeInt(n);
        packet.writeInt(0);
    }

    public static void writeReqDebug2(YasStatement yasStatement, Packet packet, DebugOperation debugOperation, int n) {
        packet.writeShort(yasStatement.getID());
        packet.writeByte((byte)debugOperation.getValue());
        packet.writeByte((byte)n);
    }

    public static Object processDebugAck(SessionImpl sessionImpl, YasDebugCallableStatement yasDebugCallableStatement, Packet packet, DebugOperation debugOperation) throws SQLException {
        int n;
        boolean bl = sessionImpl.getConnectVersion().getValue() < ConnectVersion.VER8.getValue();
        byte by = packet.getByte();
        packet.skip(1);
        if (bl) {
            packet.skip(2);
            n = packet.getInt();
        } else {
            n = packet.getShort();
        }
        DebugOperation debugOperation2 = DebugOperation.valueOf(by);
        if (debugOperation != debugOperation2) {
            throw SQLError.createSQLException("debug ack protocol error", YasState.UNKNOWN_STATE);
        }
        switch (debugOperation2) {
            case DBG_ADD_BP: {
                if (bl) {
                    packet.skip(29);
                }
                packet.getRowSize();
                return packet.getInt();
            }
            case DBG_SHOW_VARS: {
                ArrayList arrayList = new ArrayList();
                if (bl) {
                    PacketProcessor.a(sessionImpl, packet, n, arrayList);
                } else {
                    PacketProcessor.b(sessionImpl, packet, n, arrayList);
                }
                return arrayList;
            }
            case DBG_SHOW_FRAMES: {
                ArrayList arrayList = new ArrayList();
                if (bl) {
                    PacketProcessor.c(sessionImpl, packet, n, arrayList);
                } else {
                    PacketProcessor.d(sessionImpl, packet, n, arrayList);
                }
                return arrayList;
            }
            case DBG_START: 
            case DBG_CONTINUE: 
            case DBG_STEP_INTO: 
            case DBG_STEP_NEXT: 
            case DBG_STEP_OUT: {
                if (bl) {
                    PacketProcessor.a(sessionImpl, yasDebugCallableStatement, packet);
                    break;
                }
                PacketProcessor.b(sessionImpl, yasDebugCallableStatement, packet);
                break;
            }
            case DBG_DEL_BP: 
            case DBG_CHECK_VERSION: {
                break;
            }
            default: {
                throw SQLError.createSQLException("debug ack protocol error", YasState.UNKNOWN_STATE);
            }
        }
        return null;
    }

    public static YasResultSet processExecuteAck(StatementImpl statementImpl, Packet packet, SessionImpl sessionImpl, DebugOperation debugOperation) throws SQLException {
        if (debugOperation != null) {
            if (packet.getCmd() == MsgType.CMD_DEBUG) {
                PacketProcessor.processDebugAck(sessionImpl, (YasDebugCallableStatement)statementImpl, packet, debugOperation);
                return null;
            }
            sessionImpl.setDebugOff();
        }
        return PacketProcessor.processExecuteAck(statementImpl, packet, sessionImpl);
    }

    private static Object a(SessionImpl sessionImpl, Packet packet, int n) throws SQLException {
        int n2;
        boolean bl;
        boolean bl2 = bl = sessionImpl.getConnectVersion().getValue() < ConnectVersion.VER8.getValue();
        if (packet.hasReadToEnd()) {
            packet = bl ? sessionImpl.moreData() : sessionImpl.moreData2();
        }
        if ((n2 = packet.getRowSize()) <= 0) {
            return null;
        }
        byte[] byArray = packet.getBytes(n2);
        if (n == 35 || n == 29 || n == 30) {
            n = 26;
        }
        Accessor accessor = AccessorFactory.generateAccessorByDataType(n, sessionImpl);
        switch (n) {
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return accessor.getString(byArray);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 40: {
                return accessor.getBigDecimal(byArray);
            }
            case 13: 
            case 14: {
                return accessor.getDate(byArray, null);
            }
            case 15: {
                return accessor.getTime(byArray, null);
            }
            case 16: 
            case 17: 
            case 18: {
                return accessor.getTimestamp(byArray, null);
            }
            case 1: {
                return accessor.getBoolean(byArray);
            }
            case 31: {
                return accessor.getByte(byArray);
            }
            case 32: {
                return accessor.getRowId(byArray);
            }
            case 0: 
            case 34: {
                return null;
            }
        }
        throw SQLError.createSQLException("Unexpected DataType " + n, YasState.DATA_ERROR);
    }

    private static void a(SessionImpl sessionImpl, Packet packet, int n, ArrayList arrayList) throws SQLException {
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            if (packet.hasReadToEnd()) {
                packet = sessionImpl.moreData();
            }
            DebugVarImpl debugVarImpl = new DebugVarImpl();
            DebugVarInfo debugVarInfo = new DebugVarInfo(packet);
            int n3 = debugVarInfo.getType();
            debugVarImpl.setName(debugVarInfo.getName());
            debugVarImpl.setDataType(n3);
            debugVarImpl.setBlockNo(debugVarInfo.getBlockNo());
            debugVarImpl.setGlobal(debugVarInfo.isGlobal());
            debugVarImpl.setVariable(PacketProcessor.a(sessionImpl, packet, n3));
            arrayList.add(debugVarImpl);
        }
    }

    private static void b(SessionImpl sessionImpl, Packet packet, int n, ArrayList arrayList) throws SQLException {
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            if (packet.hasReadToEnd()) {
                packet = sessionImpl.moreData2();
            }
            DebugVarImpl debugVarImpl = new DebugVarImpl();
            DebugVariantInfo debugVariantInfo = new DebugVariantInfo(sessionImpl, packet);
            int n3 = debugVariantInfo.getType();
            debugVarImpl.setName(debugVariantInfo.getName());
            debugVarImpl.setDataType(n3);
            debugVarImpl.setBlockNo(debugVariantInfo.getBlockNo());
            debugVarImpl.setGlobal(debugVariantInfo.isGlobal());
            debugVarImpl.setVariable(PacketProcessor.a(sessionImpl, packet, n3));
            arrayList.add(debugVarImpl);
        }
    }

    private static void c(SessionImpl sessionImpl, Packet packet, int n, ArrayList arrayList) throws SQLException {
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            int n3;
            if (packet.hasReadToEnd()) {
                packet = sessionImpl.moreData();
            }
            DebugFrameImpl debugFrameImpl = new DebugFrameImpl();
            DebugVarInfo debugVarInfo = new DebugVarInfo(packet);
            int n4 = debugVarInfo.getType();
            debugFrameImpl.setClassInfo(debugVarInfo.getName());
            debugFrameImpl.setLineNum(debugVarInfo.getLineNo());
            debugFrameImpl.setBlockNo(debugVarInfo.getBlockNo());
            if (n4 != 24 && n4 != 26 && n4 != 25 && n4 != 27) {
                throw SQLError.createSQLException("Unexpected DataType", YasState.UNKNOWN_STATE);
            }
            if (packet.hasReadToEnd()) {
                packet = sessionImpl.moreData();
            }
            if ((n3 = packet.getRowSize()) > 0) {
                byte[] byArray = new byte[n3];
                packet.getBytes(n3, byArray);
                String string = new String(byArray, CharacterSet.getCharSet(sessionImpl.getCharset()));
                debugFrameImpl.setMethodInfo(string);
            }
            arrayList.add(debugFrameImpl);
        }
    }

    private static void d(SessionImpl sessionImpl, Packet packet, int n, ArrayList arrayList) throws SQLException {
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            if (packet.hasReadToEnd()) {
                packet = sessionImpl.moreData2();
            }
            DebugFrameImpl debugFrameImpl = new DebugFrameImpl();
            DebugFrameInfo debugFrameInfo = new DebugFrameInfo(sessionImpl, packet);
            debugFrameImpl.setObjectId(debugFrameInfo.getObjectId());
            debugFrameImpl.setSubId(debugFrameInfo.getSubProgramId());
            debugFrameImpl.setLineNum(debugFrameInfo.getLineNo());
            debugFrameImpl.setBlockNo(debugFrameInfo.getStackNo());
            debugFrameImpl.setClassInfo(debugFrameInfo.getClassName());
            debugFrameImpl.setMethodInfo(debugFrameInfo.getMethodName());
            arrayList.add(debugFrameImpl);
        }
    }

    private static void a(SessionImpl sessionImpl, YasDebugCallableStatement yasDebugCallableStatement, Packet packet) throws SQLException {
        DebugVarInfo debugVarInfo = new DebugVarInfo(packet);
        int n = debugVarInfo.getType();
        if (n != 3 && n != 4 && n != 5 && n != 2 && n != 10 && n != 11 && n != 12) {
            throw SQLError.createSQLException("Unexpected DataType", YasState.UNKNOWN_STATE);
        }
        int n2 = packet.getRowSize();
        if (n2 > 0) {
            BigDecimal bigDecimal = ByteConverter.toBigDecimal(packet.getBytes(n2), 0);
            sessionImpl.updateDebugStatus(yasDebugCallableStatement, debugVarInfo.getObjectId(), debugVarInfo.getSubId(), bigDecimal.intValue());
        }
    }

    private static void b(SessionImpl sessionImpl, YasDebugCallableStatement yasDebugCallableStatement, Packet packet) throws SQLException {
        DebugFrameInfo debugFrameInfo = new DebugFrameInfo(sessionImpl, packet);
        sessionImpl.updateDebugStatus(yasDebugCallableStatement, debugFrameInfo.getObjectId(), debugFrameInfo.getSubProgramId(), debugFrameInfo.getLineNo());
    }

    public static boolean hasMoreRows(Packet packet) {
        long l = packet.getLong(16);
        return (l & 0x100000000000L) != 0L;
    }

    public static Packet getXAReqPacket(Packet packet, byte by, Xid xid, int n, int n2) throws XAException {
        YasXAConnection.checkXid(xid);
        packet.writeByte(by);
        packet.skip(1);
        packet.writeByte((byte)xid.getGlobalTransactionId().length);
        packet.writeByte((byte)xid.getBranchQualifier().length);
        packet.writeInt(xid.getFormatId());
        packet.writeInt(n);
        packet.writeInt(n2);
        packet.skip(4);
        packet.writeBytes(xid.getGlobalTransactionId());
        packet.writeBytes(xid.getBranchQualifier());
        return packet;
    }
}

