/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.IntervalType;
import com.yashandb.util.YasTime;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.Calendar;

public class TypeConverter {
    private TypeConverter() {
    }

    private static String a(Clob clob) throws SQLException {
        return clob.getSubString(1L, (int)clob.length());
    }

    public static int castToInt(Object object, int n) throws SQLException {
        try {
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof Clob) {
                return Integer.parseInt(TypeConverter.a((Clob)object));
            }
            if (object instanceof Character) {
                return Integer.parseInt(object.toString());
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName(), exception);
        }
        throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName());
    }

    public static long castToLong(Object object, int n) throws SQLException {
        try {
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1L : 0L;
            }
            if (object instanceof Clob) {
                return Long.parseLong(TypeConverter.a((Clob)object));
            }
            if (object instanceof Character) {
                return Long.parseLong(object.toString());
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName(), exception);
        }
        throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName());
    }

    public static float castToFloat(Object object, int n) throws SQLException {
        try {
            if (object instanceof String) {
                return Float.parseFloat((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0f : 0.0f;
            }
            if (object instanceof Clob) {
                return Float.parseFloat(TypeConverter.a((Clob)object));
            }
            if (object instanceof Character) {
                return Float.parseFloat(object.toString());
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName(), exception);
        }
        throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName());
    }

    public static double castToDouble(Object object, int n) throws SQLException {
        try {
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            if (object instanceof Clob) {
                return Double.parseDouble(TypeConverter.a((Clob)object));
            }
            if (object instanceof Character) {
                return Double.parseDouble(object.toString());
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName(), exception);
        }
        throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName());
    }

    public static BigDecimal castToBigDecimal(Object object, int n, int n2) throws SQLException {
        try {
            BigDecimal bigDecimal = null;
            if (object instanceof String) {
                bigDecimal = new BigDecimal((String)object);
            } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
                bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
            } else if (object instanceof Double || object instanceof Float) {
                bigDecimal = BigDecimal.valueOf(((Number)object).doubleValue());
            } else if (object instanceof BigDecimal) {
                bigDecimal = (BigDecimal)object;
            } else if (object instanceof Boolean) {
                bigDecimal = (Boolean)object != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (object instanceof BigInteger) {
                bigDecimal = new BigDecimal((BigInteger)object);
            } else if (object instanceof Clob) {
                bigDecimal = new BigDecimal(TypeConverter.a((Clob)object));
            } else if (object instanceof Character) {
                bigDecimal = new BigDecimal(new char[]{((Character)object).charValue()});
            } else {
                throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n2).getName());
            }
            if (n >= 0) {
                bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n2).getName(), exception);
        }
    }

    public static String castToString(Object object, int n) throws SQLException {
        try {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Clob) {
                return TypeConverter.a((Clob)object);
            }
            if (object instanceof byte[]) {
                return new String((byte[])object);
            }
            if (object instanceof Boolean || object instanceof Number || object instanceof java.util.Date || object instanceof Calendar || object instanceof LocalDate || object instanceof LocalTime || object instanceof LocalDateTime || object instanceof OffsetTime || object instanceof OffsetDateTime) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName(), exception);
        }
        throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n).getName());
    }

    public static Timestamp castToTimeStamp(Object object) throws SQLException {
        try {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            if (object instanceof Date) {
                return new Timestamp(((java.util.Date)object).getTime());
            }
            if (object instanceof Time) {
                return new Timestamp(((Time)object).getTime());
            }
            if (object instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)object).getTime());
            }
            if (object instanceof Calendar) {
                return new Timestamp(((Calendar)object).getTimeInMillis());
            }
            if (object instanceof LocalDateTime) {
                return Timestamp.valueOf((LocalDateTime)object);
            }
            if (object instanceof String) {
                return Timestamp.valueOf((String)object);
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), "Timestamp", exception);
        }
        throw SQLError.transformException(object.getClass().getName(), "Timestamp");
    }

    public static boolean castToBoolean(Object object) throws SQLException {
        try {
            if (object instanceof String) {
                if ("TRUE".equalsIgnoreCase((String)object) || "ON".equalsIgnoreCase((String)object) || "YES".equalsIgnoreCase((String)object) || "T".equalsIgnoreCase((String)object) || "Y".equalsIgnoreCase((String)object) || "1".equals(object)) {
                    return true;
                }
                if ("FALSE".equalsIgnoreCase((String)object) || "OFF".equalsIgnoreCase((String)object) || "NO".equalsIgnoreCase((String)object) || "F".equalsIgnoreCase((String)object) || "N".equalsIgnoreCase((String)object) || "0".equals(object)) {
                    return false;
                }
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() != 0.0;
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), "Boolean", exception);
        }
        throw SQLError.transformException(object.getClass().getName(), "Boolean");
    }

    public static Time castToTime(Object object) throws SQLException {
        try {
            if (object instanceof Time) {
                return (Time)object;
            }
            if (object instanceof Timestamp) {
                YasTime yasTime = new YasTime(((Timestamp)object).getTime());
                yasTime.setNanos(((Timestamp)object).getNanos());
                return yasTime;
            }
            if (object instanceof java.util.Date) {
                return new Time(((java.util.Date)object).getTime());
            }
            if (object instanceof LocalTime) {
                return YasTime.valueOf((LocalTime)object);
            }
            if (object instanceof Calendar) {
                return new Time(((Calendar)object).getTimeInMillis());
            }
            if (object instanceof LocalDate) {
                return Time.valueOf((LocalTime)object);
            }
            if (object instanceof LocalDateTime) {
                return Time.valueOf(((LocalDateTime)object).toLocalTime());
            }
            if (object instanceof String) {
                return YasTime.valueOf((String)object);
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), "Time", exception);
        }
        throw SQLError.transformException(object.getClass().getName(), "Time");
    }

    public static Date castToDate(Object object) throws SQLException {
        try {
            if (object instanceof Date) {
                return (Date)object;
            }
            if (object instanceof String) {
                return Date.valueOf((String)object);
            }
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof Time) {
                return new Date(((Time)object).getTime());
            }
            if (object instanceof java.util.Date) {
                return new Date(((java.util.Date)object).getTime());
            }
            if (object instanceof LocalDate) {
                return Date.valueOf((LocalDate)object);
            }
            if (object instanceof LocalDateTime) {
                return Date.valueOf(((LocalDateTime)object).toLocalDate());
            }
            if (object instanceof Calendar) {
                return new Date(((Calendar)object).getTimeInMillis());
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), "Date", exception);
        }
        throw SQLError.transformException(object.getClass().getName(), "Date");
    }

    public static long castToDsInterval(Object object) throws SQLException {
        try {
            if (object instanceof String) {
                return IntervalType.convertStringToDsInterval((String)object);
            }
            if (object instanceof Duration) {
                Duration duration = (Duration)object;
                return duration.getSeconds() * 1000000L + (long)duration.getNano() / 1000L;
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), "DsInterval", exception);
        }
        throw SQLError.transformException(object.getClass().getName(), "DsInterval");
    }

    public static int castToYmInterval(Object object) throws SQLException {
        try {
            if (object instanceof String) {
                return IntervalType.convertStringToYmInterval((String)object);
            }
            if (object instanceof Period) {
                Period period = (Period)object;
                return (int)period.toTotalMonths();
            }
        }
        catch (Exception exception) {
            throw SQLError.transformException(object.getClass().getName(), "YmInterval", exception);
        }
        throw SQLError.transformException(object.getClass().getName(), "YmInterval");
    }
}

