/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.Buffer;
import com.yashandb.protocol.YasFilterInputStream;
import com.yashandb.protocol.jni.GmsslDll;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.sql.SQLException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class YasSocketConnection
implements Closeable,
Flushable {
    private String sslRootCer;
    private final SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private final HostSpec hostSpec;
    private Socket socket;
    private YasFilterInputStream yashanInput;
    private BufferedOutputStream yashanOutput;
    private boolean isTlcp = false;
    private long gmsslConn;

    public YasSocketConnection(SocketFactory socketFactory, HostSpec hostSpec, int n) throws IOException {
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        this.a(n);
    }

    public YasSocketConnection(YasSocketConnection yasSocketConnection, int n, boolean bl) throws IOException {
        int n2 = 1024;
        int n3 = 1024;
        int n4 = 0;
        boolean bl2 = false;
        try {
            n2 = yasSocketConnection.getSocket().getSendBufferSize();
            n3 = yasSocketConnection.getSocket().getReceiveBufferSize();
            n4 = yasSocketConnection.getSocket().getSoTimeout();
            bl2 = yasSocketConnection.getSocket().getKeepAlive();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!bl) {
            yasSocketConnection.close();
        }
        this.socketFactory = yasSocketConnection.socketFactory;
        this.hostSpec = yasSocketConnection.hostSpec;
        this.sslSocketFactory = yasSocketConnection.sslSocketFactory;
        this.a(n);
        this.socket.setReceiveBufferSize(n3);
        this.socket.setSendBufferSize(n2);
        this.setNetworkTimeout(n4);
        this.socket.setKeepAlive(bl2);
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSslRootCer(String string) {
        this.sslRootCer = string;
    }

    private Socket a(int n) throws IOException {
        Socket socket = this.socketFactory.createSocket();
        if (!socket.isConnected()) {
            InetSocketAddress inetSocketAddress = this.hostSpec.shouldResolve() != false ? new InetSocketAddress(this.hostSpec.getIp(), this.hostSpec.getPort()) : InetSocketAddress.createUnresolved(this.hostSpec.getIp(), this.hostSpec.getPort());
            socket.connect(inetSocketAddress, n);
        }
        this.changeSocket(socket);
        return socket;
    }

    public void initSSLSocket() throws SQLException {
        if (this.sslSocketFactory != null) {
            return;
        }
        if (this.sslRootCer == null) {
            throw SQLError.createSQLException("sslRootCer can not be null", YasState.CONNECTION_FAILURE);
        }
        try {
            String string = "SunX509";
            String string2 = "JKS";
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string);
            KeyStore keyStore = KeyStore.getInstance(string2);
            keyStore.load(null);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            String string3 = "ca";
            keyStore.setCertificateEntry(string3, certificateFactory.generateCertificate(new FileInputStream(this.sslRootCer)));
            trustManagerFactory.init(keyStore);
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
            sSLContext.getSocketFactory();
            this.sslSocketFactory = sSLContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw SQLError.createSQLException("Failed to obtain the sslContext instance. Please check the java version", YasState.UNKNOWN_STATE);
        }
        catch (Exception exception) {
            throw SQLError.createSQLException(exception.getMessage(), YasState.UNKNOWN_STATE, (Throwable)exception);
        }
    }

    public void changeSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.yashanInput = new YasFilterInputStream(this.socket.getInputStream());
        this.yashanOutput = new BufferedOutputStream(this.socket.getOutputStream(), 8192);
    }

    public void send(Buffer buffer) throws IOException {
        this.yashanOutput.write(buffer.getBuffer(), 0, buffer.getPostion());
    }

    public void receive(Buffer buffer, int n, int n2) throws IOException {
        this.yashanInput.readFully(buffer.getBuffer(), n, n2);
    }

    @Override
    public void flush() throws IOException {
        if (!this.isTlcp) {
            this.yashanOutput.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isTlcp) {
            GmsslDll.shutdown(this.gmsslConn);
        }
        this.yashanOutput.close();
        this.yashanInput.close();
        this.socket.close();
    }

    public void setNetworkTimeout(int n) throws IOException {
        this.socket.setSoTimeout(n);
    }

    public int getNetworkTimeout() throws IOException {
        return this.socket.getSoTimeout();
    }

    public void changeSocketToSsl() throws SQLException, IOException {
        this.initSSLSocket();
        this.changeSocket(this.sslSocketFactory.createSocket(this.socket, this.hostSpec.getIp(), this.hostSpec.getPort(), true));
    }

    public int getSocketFd() throws SQLException {
        try {
            if (this.socket instanceof Socket) {
                Method method = this.socket.getClass().getDeclaredMethod("getImpl", new Class[0]);
                method.setAccessible(true);
                SocketImpl socketImpl = (SocketImpl)method.invoke((Object)this.socket, new Object[0]);
                Method method2 = SocketImpl.class.getDeclaredMethod("getFileDescriptor", new Class[0]);
                method2.setAccessible(true);
                FileDescriptor fileDescriptor = (FileDescriptor)method2.invoke((Object)socketImpl, new Object[0]);
                Field field = fileDescriptor.getClass().getDeclaredField("fd");
                field.setAccessible(true);
                return (Integer)field.get(fileDescriptor);
            }
        }
        catch (Exception exception) {
            throw SQLError.createSQLException("get socket fd error", YasState.UNKNOWN_STATE);
        }
        return 0;
    }

    public void setGmsslConn(long l) {
        this.isTlcp = true;
        this.gmsslConn = l;
    }
}

