/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.BigIntAccessor;
import com.yashandb.protocol.accessor.BitAccessor;
import com.yashandb.protocol.accessor.BlobAccessor;
import com.yashandb.protocol.accessor.BooleanAccessor;
import com.yashandb.protocol.accessor.CharCommonAccessor;
import com.yashandb.protocol.accessor.ClobAccessor;
import com.yashandb.protocol.accessor.CursorAccessor;
import com.yashandb.protocol.accessor.DateAccessor;
import com.yashandb.protocol.accessor.DoubleAccessor;
import com.yashandb.protocol.accessor.DsIntervalAccessor;
import com.yashandb.protocol.accessor.FloatAccessor;
import com.yashandb.protocol.accessor.IntAccessor;
import com.yashandb.protocol.accessor.NumberAccessor;
import com.yashandb.protocol.accessor.RawAccessor;
import com.yashandb.protocol.accessor.RowIdAccessor;
import com.yashandb.protocol.accessor.SmallIntAccessor;
import com.yashandb.protocol.accessor.TimeAccessor;
import com.yashandb.protocol.accessor.TimeStampAccessor;
import com.yashandb.protocol.accessor.TinyIntAccessor;
import com.yashandb.protocol.accessor.UdtArrayAccessor;
import com.yashandb.protocol.accessor.UdtObjectAccessor;
import com.yashandb.protocol.accessor.XMLAccessor;
import com.yashandb.protocol.accessor.YASONAccessor;
import com.yashandb.protocol.accessor.YmIntervalAccessor;
import com.yashandb.util.Messages;
import java.sql.SQLException;

public class AccessorFactory {
    private AccessorFactory() {
    }

    private static Accessor a(int n) throws SQLException {
        Accessor accessor;
        switch (n) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                accessor = new CharCommonAccessor(n);
                break;
            }
            case 2: {
                accessor = new TinyIntAccessor();
                break;
            }
            case 3: {
                accessor = new SmallIntAccessor();
                break;
            }
            case 4: {
                accessor = new IntAccessor();
                break;
            }
            case 5: {
                accessor = new BigIntAccessor();
                break;
            }
            case 10: {
                accessor = new FloatAccessor();
                break;
            }
            case 11: {
                accessor = new DoubleAccessor();
                break;
            }
            case 12: 
            case 40: {
                accessor = new NumberAccessor();
                break;
            }
            case 15: {
                accessor = new TimeAccessor();
                break;
            }
            case 13: {
                accessor = new DateAccessor();
                break;
            }
            case 16: {
                accessor = new TimeStampAccessor();
                break;
            }
            case 20: {
                accessor = new DsIntervalAccessor();
                break;
            }
            case 19: {
                accessor = new YmIntervalAccessor();
                break;
            }
            case 1: {
                accessor = new BooleanAccessor();
                break;
            }
            case 31: {
                accessor = new BitAccessor();
                break;
            }
            case 32: {
                accessor = new RowIdAccessor();
                break;
            }
            case 29: 
            case 33: {
                accessor = new ClobAccessor(n);
                break;
            }
            case 35: {
                accessor = new YASONAccessor();
                break;
            }
            case 39: {
                accessor = new XMLAccessor();
                break;
            }
            case 30: {
                accessor = new BlobAccessor();
                break;
            }
            case 28: {
                accessor = new RawAccessor();
                break;
            }
            case 34: {
                accessor = new CursorAccessor();
                break;
            }
            case 36: {
                accessor = new UdtObjectAccessor();
                break;
            }
            case 37: 
            case 38: {
                accessor = new UdtArrayAccessor();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("unsupported datatype {0}", n), YasState.DATA_ERROR);
            }
        }
        return accessor;
    }

    public static Accessor[] generateAccessors(Field[] fieldArray, Session session) throws SQLException {
        Accessor[] accessorArray = new Accessor[fieldArray.length];
        for (int i = 0; i < accessorArray.length; ++i) {
            accessorArray[i] = AccessorFactory.a(fieldArray[i].getYasType());
            accessorArray[i].config(session);
        }
        return accessorArray;
    }

    public static Accessor generateAccessorByDataType(int n, Session session) throws SQLException {
        Accessor accessor = AccessorFactory.a(n);
        accessor.config(session);
        return accessor;
    }
}

