/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;

public class BitAccessor
implements Accessor {
    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(31);
    }

    @Override
    public String getString(byte[] byArray) throws SQLException {
        return ByteConverter.bitBytesToString(byArray, 0, byArray.length);
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        return Arrays.copyOfRange(byArray, n, n + n2);
    }

    @Override
    public boolean getBoolean(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        return l != 0L;
    }

    @Override
    public byte getByte(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        if (l < -128L || l > 127L) {
            throw SQLError.overFlowException("Bit", "Byte");
        }
        return (byte)l;
    }

    @Override
    public short getShort(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        if (l < -32768L || l > 32767L) {
            throw SQLError.overFlowException("Bit", "Short");
        }
        return (short)l;
    }

    @Override
    public int getInt(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw SQLError.overFlowException("Bit", "Int");
        }
        return (int)l;
    }

    @Override
    public long getLong(byte[] byArray) throws SQLException {
        return ByteConverter.bitBytesToLong(byArray);
    }

    @Override
    public float getFloat(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        if ((float)l < Float.MIN_VALUE || (float)l > Float.MAX_VALUE) {
            throw SQLError.overFlowException("Bit", "Float");
        }
        return l;
    }

    @Override
    public double getDouble(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        if ((double)l < Double.MIN_VALUE || (double)l > Double.MAX_VALUE) {
            throw SQLError.overFlowException("Bit", "Double");
        }
        return l;
    }

    @Override
    public BigDecimal getBigDecimal(byte[] byArray) throws SQLException {
        long l = ByteConverter.bitBytesToLong(byArray);
        return BigDecimal.valueOf(l);
    }
}

