/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.core.DataType;
import com.yashandb.jdbc.YasRowID;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.Utils;
import com.yashandb.util.YasTime;
import com.yashandb.util.YasTimestamp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CharCommonAccessor
implements Accessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CharCommonAccessor.class);
    private static final String STR_TYPE = "String";
    private static final DateTimeFormatter YAS_DATE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 9, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().optionalEnd().optionalStart().appendLiteral(' ').appendZoneId().optionalEnd().toFormatter();
    private static final DateTimeFormatter YAS_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().optionalStart().appendLiteral(' ').appendZoneId().optionalEnd().toFormatter();
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{YAS_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME, YAS_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_LOCAL_TIME};
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss z", "HH:mm:ss"};
    private int dataType;
    private Charset charset = StandardCharsets.UTF_8;

    public CharCommonAccessor(int n) {
        this.dataType = n;
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(this.dataType);
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        if (byArray == null) {
            return null;
        }
        return new String(byArray, n, n2, this.charset);
    }

    private String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(byArray, this.charset);
    }

    @Override
    public RowId getRowId(byte[] byArray) throws SQLException {
        String string = this.a(byArray);
        if (string == null) {
            return null;
        }
        return new YasRowID(string.trim());
    }

    @Override
    public String getString(byte[] byArray) {
        return this.a(byArray);
    }

    @Override
    public boolean getBoolean(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        if ("TRUE".equalsIgnoreCase(string) || "ON".equalsIgnoreCase(string) || "YES".equalsIgnoreCase(string) || "T".equalsIgnoreCase(string) || "1".equals(string) || "Y".equalsIgnoreCase(string)) {
            return true;
        }
        if ("FALSE".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string) || "NO".equalsIgnoreCase(string) || "F".equalsIgnoreCase(string) || "0".equals(string) || "N".equalsIgnoreCase(string)) {
            return false;
        }
        YasException yasException = SQLError.convertValueException(STR_TYPE, string, "Boolean");
        LOGGER.warn(yasException.getMessage());
        throw yasException;
    }

    @Override
    public byte getByte(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return Byte.parseByte(string);
        }
        catch (Exception exception) {
            try {
                return Double.valueOf(string).byteValue();
            }
            catch (Exception exception2) {
                LOGGER.warn(exception.getMessage() + "\n" + exception2.getMessage());
                throw SQLError.convertValueException(STR_TYPE, string, "Byte");
            }
        }
    }

    @Override
    public short getShort(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(string).shortValue();
            }
            catch (NumberFormatException numberFormatException2) {
                LOGGER.warn(numberFormatException.getMessage() + "\n" + numberFormatException2.getMessage());
                throw SQLError.convertValueException(STR_TYPE, string, "Short", numberFormatException2);
            }
        }
    }

    @Override
    public int getInt(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(string).intValue();
            }
            catch (NumberFormatException numberFormatException2) {
                LOGGER.warn(numberFormatException.getMessage() + "\n" + numberFormatException2.getMessage());
                throw SQLError.convertValueException(STR_TYPE, string, "Int", numberFormatException2);
            }
        }
    }

    @Override
    public long getLong(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(string).longValue();
            }
            catch (NumberFormatException numberFormatException2) {
                LOGGER.warn(numberFormatException.getMessage() + "\n" + numberFormatException2.getMessage());
                throw SQLError.convertValueException(STR_TYPE, string, "Long");
            }
        }
    }

    @Override
    public float getFloat(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException2) {
                LOGGER.warn(numberFormatException.getMessage() + "\n" + numberFormatException2.getMessage());
                throw SQLError.convertValueException(STR_TYPE, string, "Float", numberFormatException2);
            }
        }
    }

    @Override
    public double getDouble(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new BigDecimal(string).doubleValue();
            }
            catch (NumberFormatException numberFormatException2) {
                LOGGER.warn(numberFormatException.getMessage() + "\n" + numberFormatException2.getMessage());
                throw SQLError.convertValueException(STR_TYPE, string, "Double", numberFormatException2);
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn(numberFormatException.getMessage());
            throw SQLError.convertValueException(STR_TYPE, string, "BigDecimal", numberFormatException);
        }
    }

    @Override
    public Time getTime(byte[] byArray, Calendar calendar) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        LocalTime localTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                localTime = LocalTime.parse(string, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
                localTime = null;
            }
        }
        if (localTime == null) {
            YasException yasException = SQLError.convertValueException(STR_TYPE, string, "Time");
            LOGGER.warn(yasException.getMessage());
            throw yasException;
        }
        return YasTime.valueOf(localTime);
    }

    private Date a(String string) {
        try {
            return Date.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                return new Date(timestamp.getTime());
            }
            catch (Exception exception) {
                throw illegalArgumentException;
            }
        }
    }

    @Override
    public Date getDate(byte[] byArray, Calendar calendar) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return this.a(string);
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage());
            throw SQLError.convertValueException(STR_TYPE, string, "Date", exception);
        }
    }

    private Timestamp b(String string) {
        try {
            return YasTimestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("Timestamp format must be yyyy-mm-dd hh:mm:ss")) {
                try {
                    Date date = Date.valueOf(string);
                    return new Timestamp(date.getTime());
                }
                catch (Exception exception) {
                    throw illegalArgumentException;
                }
            }
            throw illegalArgumentException;
        }
    }

    @Override
    public Timestamp getTimestamp(byte[] byArray, Calendar calendar) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        try {
            return this.b(string);
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage());
            throw SQLError.convertValueException(STR_TYPE, string, "Timestamp", exception);
        }
    }

    @Override
    public LocalDateTime getLocalDateTime(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        LocalDateTime localDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                localDateTime = LocalDateTime.parse(string, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
                localDateTime = null;
            }
        }
        if (localDateTime == null) {
            throw SQLError.convertValueException(STR_TYPE, string, "LocalDateTime");
        }
        if (localDateTime.getYear() < 0) {
            localDateTime = localDateTime.minusYears(-1L);
        }
        return localDateTime;
    }

    @Override
    public LocalDate getLocalDate(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        LocalDate localDate = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                localDate = LocalDate.parse(string, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
                localDate = null;
            }
        }
        if (localDate == null) {
            throw SQLError.convertValueException(STR_TYPE, string, "LocalDate");
        }
        if (localDate.getYear() < 0) {
            localDate = localDate.minusYears(-1L);
        }
        return localDate;
    }

    @Override
    public LocalTime getLocalTime(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                return LocalTime.parse(string, dateTimeFormatter);
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw SQLError.convertValueException(STR_TYPE, string, "LocalTime");
    }

    @Override
    public OffsetDateTime getOffsetDateTime(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        OffsetDateTime offsetDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                offsetDateTime = OffsetDateTime.parse(string, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
                offsetDateTime = null;
            }
        }
        if (offsetDateTime == null) {
            throw SQLError.convertValueException(STR_TYPE, string, "OffsetDateTime");
        }
        if (offsetDateTime.getYear() < 0) {
            offsetDateTime = offsetDateTime.minusYears(-1L);
        }
        return offsetDateTime;
    }

    @Override
    public OffsetTime getOffsetTime(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                return OffsetTime.parse(string, dateTimeFormatter);
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw SQLError.convertValueException(STR_TYPE, string, "OffsetTime");
    }

    @Override
    public ZonedDateTime getZonedDateTime(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        ZonedDateTime zonedDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                zonedDateTime = ZonedDateTime.parse(string, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
                zonedDateTime = null;
            }
        }
        if (zonedDateTime == null) {
            throw SQLError.convertValueException(STR_TYPE, string, "ZonedDateTime");
        }
        if (zonedDateTime.getYear() < 0) {
            zonedDateTime = zonedDateTime.minusYears(-1L);
        }
        return zonedDateTime;
    }

    @Override
    public Reader getCharacterStream(byte[] byArray) throws SQLException {
        String string = this.a(byArray);
        return new StringReader(string);
    }

    @Override
    public InputStream getBinaryStream(byte[] byArray) throws SQLException {
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public java.util.Date getJavaUtilDate(byte[] byArray) throws SQLException {
        String string = Utils.trimString(this.a(byArray));
        java.util.Date date = null;
        for (String string2 : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                continue;
            }
            if (date != null) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                if (gregorianCalendar.isSet(0) && gregorianCalendar.get(0) == 0 && gregorianCalendar.get(1) != 1) {
                    gregorianCalendar.set(1, gregorianCalendar.get(1) - 1);
                    date = gregorianCalendar.getTime();
                }
            }
            return date;
        }
        throw SQLError.convertValueException(STR_TYPE, string, "java.util.Date");
    }

    @Override
    public Calendar getCalendar(byte[] byArray) throws SQLException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(this.getJavaUtilDate(byArray));
        return calendar;
    }

    @Override
    public void config(Session session) {
        if (this.dataType == 25 || this.dataType == 27) {
            this.charset = CharacterSet.getCharSet(session.getNCharset());
            return;
        }
        this.charset = CharacterSet.getCharSet(session.getCharset());
    }
}

