/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.YasNClob;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.LobAccessor;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class ClobAccessor
extends LobAccessor {
    private int dataType;

    public ClobAccessor(int n) {
        this.dataType = n;
    }

    @Override
    public YasClob getClob(byte[] byArray, Session session) throws SQLException {
        YasLobProcessor yasLobProcessor = this.getLobProcessor(byArray, session, this.dataType);
        YasClob yasClob = new YasClob(false);
        yasClob.setLobProcessor(yasLobProcessor);
        yasClob.setConnection(session.getConnection());
        return yasClob;
    }

    @Override
    public YasNClob getNClob(byte[] byArray, Session session) throws SQLException {
        YasLobProcessor yasLobProcessor = this.getLobProcessor(byArray, session, this.dataType);
        YasNClob yasNClob = new YasNClob(false);
        yasNClob.setLobProcessor(yasLobProcessor);
        yasNClob.setConnection(session.getConnection());
        return yasNClob;
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        YasLobProcessor yasLobProcessor = this.getLobProcessor(byArray, n, this.session, 29);
        YasClob yasClob = new YasClob(false);
        yasClob.setLobProcessor(yasLobProcessor);
        yasClob.setConnection(this.session.getConnection());
        return yasClob;
    }

    @Override
    public String getString(byte[] byArray) throws SQLException {
        YasClob yasClob = this.getClob(byArray, this.session);
        return yasClob.getSubString(1L, (int)yasClob.length());
    }

    @Override
    public Reader getCharacterStream(byte[] byArray) throws SQLException {
        YasClob yasClob = this.getClob(byArray, this.session);
        return yasClob.getCharacterStream();
    }

    @Override
    public InputStream getBinaryStream(byte[] byArray) throws SQLException {
        YasClob yasClob = this.getClob(byArray, this.session);
        return yasClob.getAsciiStream();
    }

    @Override
    public byte[] getBytes(byte[] byArray) throws SQLException {
        throw SQLError.transformException("CLOB", "BYTES");
    }
}

