/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.core.DataType;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.Utils;
import com.yashandb.util.YasTime;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;

public class DateAccessor
implements Accessor {
    protected Session session = null;
    private static final String INVALID_DATE = "invalid Date";

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(13);
    }

    @Override
    public String getString(byte[] byArray) throws SQLException {
        if (this.session != null && this.session.getMapDateToTimestamp()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return simpleDateFormat.format(this.getTimestamp(byArray, null));
        }
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        StringBuilder stringBuilder = new StringBuilder();
        Utils.append4Byte(stringBuilder, internalTimeStamp.getYear());
        stringBuilder.append("-");
        Utils.append2Byte(stringBuilder, internalTimeStamp.getMonth());
        stringBuilder.append("-");
        Utils.append2Byte(stringBuilder, internalTimeStamp.getDate());
        return stringBuilder.toString();
    }

    @Override
    public Time getTime(byte[] byArray, Calendar calendar) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        internalTimeStamp.setValueForCalendar(calendar);
        YasTime yasTime = new YasTime(calendar.getTimeInMillis());
        yasTime.setNanos(internalTimeStamp.getFraction() * 1000);
        return yasTime;
    }

    @Override
    public Date getDate(byte[] byArray, Calendar calendar) throws SQLException {
        return this.a(byArray, 0, calendar);
    }

    Date a(byte[] byArray, int n, Calendar calendar) throws SQLException {
        long l = ByteConverter.int8(byArray, n);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        if (internalTimeStamp.getYear() <= 0) {
            throw SQLError.createSQLException(INVALID_DATE, YasState.DATA_ERROR);
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        internalTimeStamp.setValueForCalendar(calendar);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        return this.a(byArray, n, null);
    }

    @Override
    public Timestamp getTimestamp(byte[] byArray, Calendar calendar) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        if (internalTimeStamp.getYear() <= 0) {
            throw SQLError.createSQLException(INVALID_DATE, YasState.DATA_ERROR);
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        internalTimeStamp.setValueForCalendar(calendar);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(internalTimeStamp.getFraction() * 1000);
        return timestamp;
    }

    @Override
    public LocalDateTime getLocalDateTime(byte[] byArray) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        if (internalTimeStamp.getYear() <= 0) {
            throw SQLError.createSQLException(INVALID_DATE, YasState.DATA_ERROR);
        }
        return internalTimeStamp.getLocalDateTime();
    }

    @Override
    public LocalDate getLocalDate(byte[] byArray) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        if (internalTimeStamp.getYear() <= 0) {
            throw SQLError.createSQLException(INVALID_DATE, YasState.DATA_ERROR);
        }
        return internalTimeStamp.getLocalDate();
    }

    @Override
    public LocalTime getLocalTime(byte[] byArray) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        return internalTimeStamp.getLocalTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(byte[] byArray) throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime(byArray);
        return OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    @Override
    public OffsetTime getOffsetTime(byte[] byArray) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        LocalTime localTime = internalTimeStamp.getLocalTime();
        return OffsetTime.of(localTime, ZoneOffset.UTC);
    }

    @Override
    public ZonedDateTime getZonedDateTime(byte[] byArray) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        if (internalTimeStamp.getYear() <= 0) {
            throw SQLError.createSQLException(INVALID_DATE, YasState.DATA_ERROR);
        }
        LocalDateTime localDateTime = internalTimeStamp.getLocalDateTime();
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        return offsetDateTime.atZoneSameInstant(offsetDateTime.getOffset());
    }

    @Override
    public java.util.Date getJavaUtilDate(byte[] byArray) throws SQLException {
        Calendar calendar = this.getCalendar(byArray);
        return calendar.getTime();
    }

    @Override
    public Calendar getCalendar(byte[] byArray) throws SQLException {
        long l = ByteConverter.int8(byArray, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(l);
        if (internalTimeStamp.getYear() <= 0) {
            throw SQLError.createSQLException(INVALID_DATE, YasState.DATA_ERROR);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        internalTimeStamp.setValueForCalendar(calendar);
        if (internalTimeStamp.getYear() > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return calendar;
    }

    @Override
    public void config(Session session) {
        this.session = session;
    }
}

