/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class DoubleAccessor
implements Accessor {
    private static final String DOUBLE_TYPE = "Double";

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(11);
    }

    private double a(byte[] byArray) {
        return ByteConverter.float8(byArray, 0);
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        return ByteConverter.float8(byArray, n);
    }

    @Override
    public String getString(byte[] byArray) {
        double d = this.a(byArray);
        return String.valueOf(d);
    }

    @Override
    public byte getByte(byte[] byArray) throws SQLException {
        Double d = this.a(byArray);
        Double d2 = -129.0;
        Double d3 = 128.0;
        if (d.compareTo(d2) <= 0 || d.compareTo(d3) >= 0) {
            throw SQLError.overFlowException(DOUBLE_TYPE, "Byte");
        }
        return d.byteValue();
    }

    @Override
    public short getShort(byte[] byArray) throws SQLException {
        Double d = this.a(byArray);
        Double d2 = -32769.0;
        Double d3 = 32768.0;
        if (d.compareTo(d2) <= 0 || d.compareTo(d3) >= 0) {
            throw SQLError.overFlowException(DOUBLE_TYPE, "Short");
        }
        return d.shortValue();
    }

    @Override
    public int getInt(byte[] byArray) throws SQLException {
        Double d = this.a(byArray);
        Double d2 = -2.147483649E9;
        Double d3 = 2.147483648E9;
        if (d.compareTo(d2) <= 0 || d.compareTo(d3) >= 0) {
            throw SQLError.overFlowException(DOUBLE_TYPE, "Int");
        }
        return d.intValue();
    }

    @Override
    public long getLong(byte[] byArray) throws SQLException {
        Double d = this.a(byArray);
        Double d2 = -9.223372036854776E18;
        Double d3 = 9.223372036854776E18;
        if (d.compareTo(d2) < 0 || d.compareTo(d3) > 0) {
            throw SQLError.overFlowException(DOUBLE_TYPE, "Long");
        }
        return d.longValue();
    }

    @Override
    public float getFloat(byte[] byArray) throws SQLException {
        double d = this.a(byArray);
        return (float)d;
    }

    @Override
    public double getDouble(byte[] byArray) throws SQLException {
        return this.a(byArray);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] byArray) throws SQLException {
        return new BigDecimal(String.valueOf(this.a(byArray)));
    }

    @Override
    public BigInteger getBigInteger(byte[] byArray) throws SQLException {
        return this.getBigDecimal(byArray).toBigInteger();
    }

    @Override
    public boolean getBoolean(byte[] byArray) throws SQLException {
        double d = this.a(byArray);
        return d != 0.0;
    }
}

