/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class FloatAccessor
implements Accessor {
    private static final String FLOAT_TYPE = "Float";

    float a(byte[] byArray) {
        return ByteConverter.float4(byArray, 0);
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        return Float.valueOf(ByteConverter.float4(byArray, n));
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(10);
    }

    @Override
    public String getString(byte[] byArray) {
        float f = this.a(byArray);
        return String.valueOf(f);
    }

    @Override
    public byte getByte(byte[] byArray) throws SQLException {
        Float f = Float.valueOf(this.a(byArray));
        Float f2 = Float.valueOf(-129.0f);
        Float f3 = Float.valueOf(128.0f);
        if (f.compareTo(f2) <= 0 || f.compareTo(f3) >= 0) {
            throw SQLError.overFlowException(FLOAT_TYPE, "Byte");
        }
        return f.byteValue();
    }

    @Override
    public short getShort(byte[] byArray) throws SQLException {
        Float f = Float.valueOf(this.a(byArray));
        Float f2 = Float.valueOf(-32769.0f);
        Float f3 = Float.valueOf(32768.0f);
        if (f.compareTo(f2) <= 0 || f.compareTo(f3) >= 0) {
            throw SQLError.overFlowException(FLOAT_TYPE, "Short");
        }
        return f.shortValue();
    }

    @Override
    public int getInt(byte[] byArray) throws SQLException {
        Float f = Float.valueOf(this.a(byArray));
        Float f2 = Float.valueOf(-2.1474836E9f);
        Float f3 = Float.valueOf(2.1474836E9f);
        if (f.compareTo(f2) <= 0 || f.compareTo(f3) >= 0) {
            throw SQLError.overFlowException(FLOAT_TYPE, "Int");
        }
        return f.intValue();
    }

    @Override
    public long getLong(byte[] byArray) throws SQLException {
        Float f = Float.valueOf(this.a(byArray));
        Float f2 = Float.valueOf(-9.223372E18f);
        Float f3 = Float.valueOf(9.223372E18f);
        if (f.compareTo(f2) < 0 || f.compareTo(f3) > 0) {
            throw SQLError.overFlowException(FLOAT_TYPE, "Long");
        }
        return f.longValue();
    }

    @Override
    public float getFloat(byte[] byArray) throws SQLException {
        return this.a(byArray);
    }

    @Override
    public double getDouble(byte[] byArray) throws SQLException {
        return this.a(byArray);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] byArray) throws SQLException {
        return new BigDecimal(String.valueOf(this.a(byArray)));
    }

    @Override
    public BigInteger getBigInteger(byte[] byArray) throws SQLException {
        return this.getBigDecimal(byArray).toBigInteger();
    }

    @Override
    public boolean getBoolean(byte[] byArray) throws SQLException {
        float f = this.a(byArray);
        return f != 0.0f;
    }
}

