/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberAccessor
implements Accessor {
    private static final String NUMBER_TYPE = "Number";

    BigDecimal a(byte[] byArray) {
        return ByteConverter.toBigDecimal(byArray, 0);
    }

    @Override
    public Object getValue(byte[] byArray, int n, int n2) throws SQLException {
        return ByteConverter.toBigDecimal(byArray, n, n2);
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(12);
    }

    @Override
    public String getString(byte[] byArray) {
        BigDecimal bigDecimal = this.a(byArray);
        return bigDecimal.toPlainString();
    }

    @Override
    public boolean getBoolean(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        return bigDecimal.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public byte getByte(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(-129L);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(128L);
        if (bigDecimal.compareTo(bigDecimal2) <= 0 || bigDecimal.compareTo(bigDecimal3) >= 0) {
            throw SQLError.overFlowException(NUMBER_TYPE, "Byte");
        }
        return bigDecimal.byteValue();
    }

    @Override
    public short getShort(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(-32769L);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(32768L);
        if (bigDecimal.compareTo(bigDecimal2) <= 0 || bigDecimal.compareTo(bigDecimal3) >= 0) {
            throw SQLError.overFlowException(NUMBER_TYPE, "Short");
        }
        return bigDecimal.shortValue();
    }

    @Override
    public int getInt(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(-2147483649L);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(0x80000000L);
        if (bigDecimal.compareTo(bigDecimal2) <= 0 || bigDecimal.compareTo(bigDecimal3) >= 0) {
            throw SQLError.overFlowException(NUMBER_TYPE, "Int");
        }
        return bigDecimal.intValue();
    }

    @Override
    public long getLong(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(Long.MIN_VALUE);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(Long.MAX_VALUE);
        if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
            throw SQLError.overFlowException(NUMBER_TYPE, "Long");
        }
        return bigDecimal.longValue();
    }

    @Override
    public float getFloat(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        return bigDecimal.floatValue();
    }

    @Override
    public double getDouble(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = this.a(byArray);
        return bigDecimal.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(byte[] byArray) throws SQLException {
        return this.a(byArray);
    }
}

