/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.debug;

import com.yashandb.SessionImpl;
import com.yashandb.protocol.Packet;
import java.sql.SQLException;

public class DebugFrameInfo {
    private long objectId;
    private int subProgramId;
    private int lineNo;
    private int stackNo;
    private int classNameLen;
    private int methodNameLen;
    private String className = null;
    private String methodName = null;

    public DebugFrameInfo(SessionImpl sessionImpl, Packet packet) throws SQLException {
        this.objectId = packet.getLong();
        this.subProgramId = packet.getShort();
        this.stackNo = packet.getShort();
        this.lineNo = packet.getInt();
        if (packet.hasReadToEnd()) {
            packet = sessionImpl.moreData();
        }
        this.classNameLen = packet.getRowSize();
        if (this.classNameLen > 0) {
            this.className = packet.getString(this.classNameLen);
        }
        if (packet.hasReadToEnd()) {
            packet = sessionImpl.moreData();
        }
        this.methodNameLen = packet.getRowSize();
        if (this.methodNameLen > 0) {
            this.methodName = packet.getString(this.methodNameLen);
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public int getSubProgramId() {
        return this.subProgramId;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getStackNo() {
        return this.stackNo;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

