/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.jni;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.jni.YasUKeyDll;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class UKeyInfo {
    private long hDev;
    private long hApp;
    private long hCon;
    private boolean closed = false;

    public UKeyInfo(String string, String string2) throws SQLException {
        byte[] byArray = YasUKeyDll.enumDevs();
        this.a();
        List list = this.a(byArray);
        for (String string3 : list) {
            long l = YasUKeyDll.connectDev(string3);
            String string4 = YasUKeyDll.getDevInfo(l);
            if (string4.equals(string)) {
                if (this.hDev != 0L) {
                    throw SQLError.createSQLException("UKEY_TOO_MANY_DEVICES", YasState.UNKNOWN_STATE);
                }
                this.hDev = l;
                continue;
            }
            YasUKeyDll.disConnectDev(this.hDev, 0L, 0L);
        }
        if (this.hDev == 0L) {
            throw SQLError.createSQLException("UKEY_NO_DEVICE", YasState.UNKNOWN_STATE);
        }
        this.hApp = YasUKeyDll.openApplication(this.hDev);
        if (YasUKeyDll.verifyPIN(this.hApp, string2) != 0) {
            YasUKeyDll.disConnectDev(this.hDev, this.hApp, 0L);
            throw SQLError.createSQLException("ukey VerifyPIN failed,ukeyName:" + string + ",pin:" + string2, YasState.UNKNOWN_STATE);
        }
        this.hCon = YasUKeyDll.openContainer(this.hApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        if (YasUKeyDll.hasAddHook.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = YasUKeyDll.hasAddHook;
        synchronized (atomicBoolean) {
            if (YasUKeyDll.hasAddHook.get()) {
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    YasUKeyDll.releaseEnv();
                }
            });
            YasUKeyDll.hasAddHook.set(true);
        }
    }

    public byte[] sign(byte[] byArray) throws SQLException {
        if (this.closed) {
            throw SQLError.createSQLException("ukey has closed", YasState.UNKNOWN_STATE);
        }
        byte[] byArray2 = YasUKeyDll.uKeyECCExternalSign(this.hDev, this.hCon, byArray);
        if (byArray2.length == 0) {
            throw SQLError.createSQLException("ukey sign error", YasState.UNKNOWN_STATE);
        }
        return byArray2;
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (YasUKeyDll.disConnectDev(this.hDev, this.hApp, this.hCon) != 0) {
            throw SQLError.createSQLException("ukey close error", YasState.UNKNOWN_STATE);
        }
        this.closed = true;
    }

    private List a(byte[] byArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (byArray[i] != 0) continue;
            linkedList.add(new String(Arrays.copyOfRange(byArray, n, i)));
            n = i + 1;
        }
        return linkedList;
    }
}

