/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.udt;

import com.yashandb.Session;
import com.yashandb.core.DataType;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.protocol.accessor.BlobAccessor;
import com.yashandb.udt.YasArray;
import com.yashandb.udt.YasStruct;
import com.yashandb.udt.YasTypeDescriptor;
import com.yashandb.util.ByteConverter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractUDT {
    public static final int MOVE_TWO_BYTE = 2;
    public static final int MOVE_FOUR_BYTE = 4;
    public static final int MOVE_EIGHT_BYTE = 8;
    public static final int PREFIX_FLAG_AS_LOB = 1;
    protected long toid;
    protected byte[] originalData;
    protected byte[] serialData;
    protected YasTypeDescriptor elementDescriptor;
    protected Session session;
    protected boolean isFinal = true;
    protected int dataLen = 0;
    protected int[] elementDateIndex;
    protected int[] elementDateSize;
    protected boolean asLob = false;

    public long getToid() {
        return this.toid;
    }

    public void setToid(long l) {
        this.toid = l;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public byte[] getSerialData() throws SQLException {
        if (this.serialData != null) {
            return this.serialData;
        }
        this.doSerialize();
        return this.serialData;
    }

    protected void setElementDateIndexAndSize(int[] nArray, int[] nArray2) {
        this.elementDateIndex = nArray;
        this.elementDateSize = nArray2;
    }

    protected abstract void doSerialize() throws SQLException;

    public void setOriginalData(byte[] byArray) {
        this.originalData = Arrays.copyOf(byArray, byArray.length);
    }

    public YasTypeDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public void setElementDescriptor(YasTypeDescriptor yasTypeDescriptor) {
        this.elementDescriptor = yasTypeDescriptor;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean bl) {
        this.isFinal = bl;
    }

    public int getDataLen() throws SQLException {
        if (this.serialData == null) {
            this.getSerialData();
        }
        return this.dataLen;
    }

    public boolean isAsLob() {
        return this.asLob;
    }

    public void setAsLob(boolean bl) {
        this.asLob = bl;
    }

    public static int[] getDataLen(byte[] byArray, int n, int n2) {
        if (DataType.isUdtType(n2)) {
            return AbstractUDT.getUdtDataLen(byArray, n);
        }
        return AbstractUDT.getBaseDataLen(byArray, n);
    }

    public static int[] getBaseDataLen(byte[] byArray, int n) {
        int[] nArray = new int[2];
        nArray[0] = byArray[n++] & 0xFF;
        if (nArray[0] == 255) {
            nArray[0] = 0;
        } else if ((nArray[0] & 0xFF) >= 253) {
            nArray[0] = ByteConverter.int2(byArray, n);
            n += 2;
        }
        nArray[1] = n;
        return nArray;
    }

    public static int[] getUdtDataLen(byte[] byArray, int n) {
        int[] nArray = new int[2];
        nArray[0] = byArray[n++] & 0xFF;
        if (nArray[0] == 255) {
            nArray[0] = 0;
        } else if ((nArray[0] & 0xFF) == 251) {
            nArray[0] = ByteConverter.int2(byArray, n);
            n += 2;
        } else if ((nArray[0] & 0xFF) == 252) {
            nArray[0] = ByteConverter.int4(byArray, n);
            n += 4;
        }
        nArray[1] = n;
        return nArray;
    }

    protected static Class getTypeClass(String string, Map map) {
        Class clazz;
        Class clazz2 = clazz = map == null ? null : (Class)map.get(string);
        if (clazz == null && string.contains(".")) {
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            clazz = map == null ? null : (Class)map.get(string2);
        }
        return clazz;
    }

    public static Object decode(byte[] byArray, int n, int n2, Session session, YasTypeDescriptor yasTypeDescriptor, int n3, Map map) throws SQLException {
        switch (n3) {
            case 36: {
                return YasStruct.decodeDfs(byArray, n, session, yasTypeDescriptor, map);
            }
            case 37: 
            case 38: {
                return YasArray.decodeDfs(byArray, n, session, yasTypeDescriptor);
            }
        }
        Accessor accessor = AccessorFactory.generateAccessorByDataType(n3, session);
        return accessor.getValue(byArray, n, n2);
    }

    public static byte[] decodeAsLob(byte[] byArray, int n, Session session) throws SQLException {
        int n2;
        if (((n2 = byArray[n++] & 0xFF) & 0xFF) >= 253) {
            n += 2;
        }
        BlobAccessor blobAccessor = (BlobAccessor)AccessorFactory.generateAccessorByDataType(30, session);
        YasBlob yasBlob = blobAccessor.getBlob(byArray, n, session);
        byte[] byArray2 = yasBlob.getBytes(1L, (int)yasBlob.length());
        yasBlob.free();
        return byArray2;
    }
}

